/*
 * Decompiled with CFR 0.152.
 */
package pl.imgw.odimH5.util;

import org.apache.xerces.parsers.DOMParser;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import pl.imgw.odimH5.model.rainbow.RainbowModel;
import pl.imgw.odimH5.util.BaltradOptions;
import pl.imgw.odimH5.util.FTP_Options;
import pl.imgw.odimH5.util.MessageLogger;
import pl.imgw.odimH5.util.RadarOptions;

public class OptionsHandler {
    public static final String OPTION_XML_FILE = "options.xml";
    public static final String NAME = "name";
    public static final String LOCATION = "location";
    public static final String WMO_ID = "WMO_id";
    public static final String FILE_NAME = "file_name";
    public static final String RADARS = "radars";
    public static final String ADDRESS = "address";
    public static final String LOGIN = "login";
    public static final String PASSWORD = "password";
    public static final String DIRECTORY = "directory";
    public static final String NRAYS = "nrays";
    public static final String FORMAT = "format";
    public static final String SERVER = "server";
    public static final String SENDER = "sender";

    public static Document loadOptions(MessageLogger msgl, boolean verbose) {
        Document doc = null;
        try {
            DOMParser parser = new DOMParser();
            parser.parse(OPTION_XML_FILE);
            doc = parser.getDocument();
            msgl.showMessage("Parsing options file: options.xml", verbose);
        }
        catch (Exception e) {
            msgl.showMessage("Failed to parse options file: " + e.getMessage(), true);
        }
        return doc;
    }

    public static RadarOptions[] getRadarOptions(Document doc) {
        NodeList radarList = doc.getElementsByTagName("radar");
        int counter = radarList.getLength();
        RadarOptions[] options = new RadarOptions[counter];
        int i = 0;
        while (i < counter) {
            options[i] = new RadarOptions();
            options[i].setRadarName(radarList.item(i).getAttributes().getNamedItem(NAME).getNodeValue());
            options[i].setLocation(RainbowModel.getValueByName(radarList.item(i), LOCATION, null));
            options[i].setRadarWMOName(RainbowModel.getValueByName(radarList.item(i), WMO_ID, null));
            options[i].setFileName(RainbowModel.getValueByName(radarList.item(i), FILE_NAME, null));
            options[i].setDir(RainbowModel.getValueByName(radarList.item(i), DIRECTORY, null));
            options[i].setNrays(RainbowModel.getValueByName(radarList.item(i), NRAYS, null));
            options[i].setFormat(RainbowModel.getValueByName(radarList.item(i), FORMAT, null));
            ++i;
        }
        return options;
    }

    public static BaltradOptions getBaltrad(Document doc) {
        NodeList baltradList = doc.getElementsByTagName("baltrad");
        BaltradOptions options = new BaltradOptions();
        if (baltradList.getLength() == 0) {
            return options;
        }
        options.setSender(RainbowModel.getValueByName(baltradList.item(0), SENDER, null));
        options.setServer(RainbowModel.getValueByName(baltradList.item(0), SERVER, null));
        return options;
    }

    public static FTP_Options[] getFTPOptions(Document doc) {
        NodeList ftpList = doc.getElementsByTagName("ftp");
        int counter = ftpList.getLength();
        FTP_Options[] options = new FTP_Options[counter];
        int i = 0;
        while (i < counter) {
            options[i] = new FTP_Options();
            String radars = RainbowModel.getValueByName(ftpList.item(i), RADARS, null);
            if (radars != null && !radars.isEmpty()) {
                options[i].setRadars(radars.split(" "));
            }
            options[i].setAddress(RainbowModel.getValueByName(ftpList.item(i), ADDRESS, null));
            options[i].setLogin(RainbowModel.getValueByName(ftpList.item(i), LOGIN, null));
            options[i].setPassword(RainbowModel.getValueByName(ftpList.item(i), PASSWORD, null));
            options[i].setDir(RainbowModel.getValueByName(ftpList.item(i), DIRECTORY, null));
            ++i;
        }
        return options;
    }

    public static int getTime(Document doc, String arg) {
        String time = OptionsHandler.getElementByName(doc, arg);
        int i = 0;
        try {
            i = Integer.valueOf(time);
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
        }
        return i;
    }

    private static String getElementByName(Document doc, String argName) {
        NodeList nodeList = null;
        nodeList = doc.getElementsByTagName(argName);
        return nodeList.item(0).getFirstChild().getNodeValue();
    }

    public static void exampleOptionXML() {
        System.out.println("<?xml version=\"1.0\" ?>");
        System.out.println("<!-- FTP options -->");
        System.out.println("<options>");
        System.out.println("    <radar name=\"NAME\">");
        System.out.println("        <WMO_id>WMO_ID</WMO_id>");
        System.out.println("        <file_name>FILE_NAME_PREFIX</file_name>");
        System.out.println("        <directory>LOCAL_DIR</directory>");
        System.out.println("        <nrays>number of rays</nrays>");
        System.out.println("        <format>file format</format>");
        System.out.println("    </radar>");
        System.out.println("    <ftp>");
        System.out.println("        <radars>LIST OF RADARS</radars>");
        System.out.println("        <address>FTP_SERVER</address>");
        System.out.println("        <login>LOGIN</login>");
        System.out.println("        <password>PASS</password>");
        System.out.println("        <directory>DIR</directory>");
        System.out.println("    </ftp>");
        System.out.println("    <baltrad>");
        System.out.println("        <server>HTTP_address</server>");
        System.out.println("        <sender>Baltrad.IMGW.pl</sender>");
        System.out.println("    </baltrad>");
        System.out.println("</options>\n\n");
        System.out.println("<address> <login> and <password> are optional for FTP handling.");
    }
}

