/*
 * Decompiled with CFR 0.152.
 */
package pl.imgw.odimH5.util;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.text.SimpleDateFormat;
import java.util.Calendar;

public class LogsHandler {
    public static final String PROGRAM_LOGS_FILE = "error.log";

    public static void saveProgramLogs(String className, String text) {
        SimpleDateFormat sdf = new SimpleDateFormat("MM/dd HH:mm");
        Calendar cal = Calendar.getInstance();
        LogsHandler.saveLine(String.valueOf(sdf.format(cal.getTime())) + "; [" + className + "] " + text, PROGRAM_LOGS_FILE, cal.getTimeZone().getID());
    }

    public static void saveProgramLogs(String text) {
        SimpleDateFormat sdf = new SimpleDateFormat("MM/dd HH:mm");
        Calendar cal = Calendar.getInstance();
        LogsHandler.saveLine(String.valueOf(sdf.format(cal.getTime())) + "; " + text, PROGRAM_LOGS_FILE, cal.getTimeZone().getID());
    }

    private static void saveLine(String text, String pathName, String timeZone) {
        File file = new File(pathName);
        if (!file.canRead()) {
            try {
                FileOutputStream fileStream = new FileOutputStream(pathName);
                PrintWriter pw = new PrintWriter(fileStream, true);
                pw.println("// Time zone: " + timeZone);
                fileStream.close();
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        try {
            RandomAccessFile rf = new RandomAccessFile(pathName, "rw");
            FileChannel fc = rf.getChannel();
            fc.position(fc.size());
            fc.write(ByteBuffer.wrap((String.valueOf(text) + "\n").getBytes()));
            fc.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

