/*
 * Decompiled with CFR 0.152.
 */
package pl.imgw.odimH5.util;

import eu.baltrad.frame.model.BaltradFrame;
import eu.baltrad.frame.model.BaltradFrameHandler;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.SocketException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.TimeUnit;
import name.pachler.nio.file.ClosedWatchServiceException;
import name.pachler.nio.file.FileSystems;
import name.pachler.nio.file.Path;
import name.pachler.nio.file.Paths;
import name.pachler.nio.file.StandardWatchEventKind;
import name.pachler.nio.file.WatchEvent;
import name.pachler.nio.file.WatchKey;
import name.pachler.nio.file.WatchService;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPReply;
import org.apache.commons.net.io.CopyStreamException;
import org.w3c.dom.Document;
import pl.imgw.odimH5.model.HDF5Model;
import pl.imgw.odimH5.model.rainbow.HDF2RainbowPVOL;
import pl.imgw.odimH5.model.rainbow.Rainbow2HDFPVOL;
import pl.imgw.odimH5.model.rainbow.RainbowModel;
import pl.imgw.odimH5.util.BaltradOptions;
import pl.imgw.odimH5.util.FTP_Options;
import pl.imgw.odimH5.util.LogsHandler;
import pl.imgw.odimH5.util.MessageLogger;
import pl.imgw.odimH5.util.OptionsHandler;
import pl.imgw.odimH5.util.RadarOptions;

public class LocalFeeder
extends Thread {
    WatchService watchService = FileSystems.getDefault().newWatchService();
    private RadarOptions[] radarOptions;
    private FTP_Options[] ftpOptions;
    private BaltradOptions baltradOptions;
    Path[] watchedPath;
    HashMap<WatchKey, RadarOptions> pathMap = new HashMap();
    HashMap<String, Long> fileTimeMap = new HashMap();
    private RainbowModel rb;
    private MessageLogger msgl;
    private boolean verbose;

    public LocalFeeder(Document optionsDoc, RainbowModel rb, HDF5Model proc, MessageLogger msgl, boolean verbose) {
        this.rb = rb;
        this.verbose = verbose;
        this.msgl = msgl;
        this.radarOptions = OptionsHandler.getRadarOptions(optionsDoc);
        this.ftpOptions = OptionsHandler.getFTPOptions(optionsDoc);
        this.baltradOptions = OptionsHandler.getBaltrad(optionsDoc);
        this.watchedPath = new Path[this.radarOptions.length];
        WatchKey[] key = new WatchKey[this.radarOptions.length];
        int i = 0;
        while (i < this.radarOptions.length) {
            if (!this.radarOptions[i].isEmpty()) {
                this.watchedPath[i] = Paths.get((String)this.radarOptions[i].getDir());
                try {
                    key[i] = this.watchedPath[i].register(this.watchService, new WatchEvent.Kind[]{StandardWatchEventKind.ENTRY_CREATE, StandardWatchEventKind.ENTRY_MODIFY});
                    this.pathMap.put(key[i], this.radarOptions[i]);
                }
                catch (UnsupportedOperationException uox) {
                    System.err.println("file watching not supported!");
                }
                catch (IOException iox) {
                    System.err.println("I/O errors");
                }
            }
            ++i;
        }
    }

    private void convertAndSendFile(String filePath) throws Exception {
        if (filePath.contains("KDP") || filePath.contains("PhiDP") || filePath.contains("HV") || filePath.contains("ZDR")) {
            new File(filePath).delete();
            return;
        }
        File originalFile = new File(filePath);
        if (!originalFile.canRead()) {
            return;
        }
        if (originalFile.getName().startsWith(".")) {
            return;
        }
        File toBeSentFile = null;
        String toBeSentFileName = "";
        String radarName = "";
        String radarFullName = "";
        String extension = "";
        boolean sentOk = false;
        if (originalFile.getName().endsWith(".vol")) {
            int file_len = (int)originalFile.length();
            byte[] file_buf = new byte[file_len];
            try {
                FileInputStream fis = new FileInputStream(originalFile);
                fis.read(file_buf, 0, file_len);
                fis.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            Rainbow2HDFPVOL vol = new Rainbow2HDFPVOL("", file_buf, this.verbose, this.rb, this.radarOptions);
            vol.makeH5();
            radarName = vol.getRadarName();
            toBeSentFileName = vol.getOutputFileName();
            toBeSentFile = new File(toBeSentFileName);
            radarFullName = vol.getRadarFullName();
        } else if (originalFile.getName().endsWith(".h5") || originalFile.getName().endsWith(".hdf")) {
            HDF2RainbowPVOL hdf = new HDF2RainbowPVOL("", filePath, this.verbose, this.rb, this.radarOptions);
            radarName = hdf.getRadarName();
            toBeSentFileName = hdf.getOutputFileName();
            toBeSentFile = new File(toBeSentFileName);
        } else {
            System.out.println("Format of " + originalFile.getName() + "not supported");
            return;
        }
        if (toBeSentFile != null && this.ftpOptions != null) {
            int i = 0;
            while (i < this.ftpOptions.length) {
                if (!this.ftpOptions[i].isEmpty()) {
                    int j = 0;
                    while (j < this.ftpOptions[i].getRadars().length) {
                        if (radarName.matches(this.ftpOptions[i].getRadars()[j])) {
                            String toBeSentFileTempName = "";
                            String remoteFolder = "";
                            if (toBeSentFileName.endsWith("vol")) {
                                toBeSentFileTempName = toBeSentFileName.replace("vol", "tmp");
                                remoteFolder = radarName;
                                extension = "vol";
                            } else {
                                toBeSentFileTempName = toBeSentFileName.replace("h5", "tmp");
                                extension = "hdf";
                            }
                            try {
                                sentOk = this.storeFileOnServer(this.ftpOptions[i], toBeSentFileName, toBeSentFileTempName, remoteFolder, extension);
                                this.msgl.showMessage(String.valueOf(radarName) + ": " + "file " + toBeSentFileName.substring(0, toBeSentFileName.indexOf(".") + 1) + extension + " sent to " + this.ftpOptions[i].getAddress(), sentOk);
                            }
                            catch (CopyStreamException e) {
                                LogsHandler.saveProgramLogs(e.getMessage());
                                this.msgl.showMessage(String.valueOf(radarName) + ": " + toBeSentFileName.substring(0, toBeSentFileName.indexOf(".") + 1) + extension + " cannot be sent to " + this.ftpOptions[i].getAddress(), true);
                            }
                            catch (IOException e) {
                                LogsHandler.saveProgramLogs(e.getMessage());
                                this.msgl.showMessage(String.valueOf(radarName) + ": " + toBeSentFileName.substring(0, toBeSentFileName.indexOf(".") + 1) + extension + " cannot be sent to " + this.ftpOptions[i].getAddress(), true);
                            }
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }
        if (toBeSentFile != null && (toBeSentFile.getName().endsWith("h5") || toBeSentFile.getName().endsWith("hdf")) && !this.baltradOptions.isEmpty()) {
            String a;
            BaltradFrame bf;
            BaltradFrameHandler bfh = new BaltradFrameHandler(this.baltradOptions.getServer());
            if (bfh.handleBF(bf = new BaltradFrame(a = bfh.createDataHdr("multipart/form-data", this.baltradOptions.getSender(), radarFullName, toBeSentFileName), toBeSentFileName)) == 0) {
                this.msgl.showMessage(String.valueOf(radarName) + ": file " + toBeSentFileName + " sent to BALTRAD", true);
            } else {
                this.msgl.showMessage(String.valueOf(radarName) + " failed to send file to BALTRAD", true);
            }
        }
        originalFile.delete();
        toBeSentFile.delete();
    }

    private boolean storeFileOnServer(FTP_Options ftpOptions, String toBeSentFileName, String sendFileTempName, String remoteFolder, String extension) throws SocketException, IOException {
        FTPClient ftp = new FTPClient();
        ftp.connect(ftpOptions.getAddress());
        int reply = ftp.getReplyCode();
        if (!FTPReply.isPositiveCompletion((int)reply)) {
            ftp.disconnect();
            System.err.println("FTP server refused connection.");
            return false;
        }
        ftp.login(ftpOptions.getLogin(), ftpOptions.getPassword());
        ftp.changeWorkingDirectory(ftpOptions.getDir());
        if (!remoteFolder.isEmpty()) {
            ftp.changeWorkingDirectory(remoteFolder);
        }
        ftp.setFileType(2);
        FileInputStream fis = null;
        fis = new FileInputStream(toBeSentFileName);
        ftp.storeFile(sendFileTempName, (InputStream)fis);
        fis.close();
        boolean ok = false;
        if (toBeSentFileName.endsWith("h5")) {
            toBeSentFileName = toBeSentFileName.replace("h5", "hdf");
        }
        ok = ftp.rename(sendFileTempName, toBeSentFileName);
        ftp.disconnect();
        return ok;
    }

    @Override
    public void run() {
        block10: while (true) {
            WatchKey signalledKey;
            try {
                signalledKey = this.watchService.poll(2L, TimeUnit.SECONDS);
            }
            catch (InterruptedException ix) {
                System.out.println("watch service interrupted.");
                continue;
            }
            catch (ClosedWatchServiceException cwse) {
                System.out.println("watch service closed, terminating.");
                break;
            }
            if (signalledKey == null) {
                long timeNow = System.currentTimeMillis();
                Iterator<String> itr = this.fileTimeMap.keySet().iterator();
                while (itr.hasNext()) {
                    String key = itr.next();
                    long time = this.fileTimeMap.get(key);
                    if (timeNow - time <= 1000L) continue;
                    this.fileTimeMap.remove(key);
                    itr = this.fileTimeMap.keySet().iterator();
                    this.msgl.showMessage(String.valueOf(key) + " download finished", true);
                    try {
                        this.convertAndSendFile(key);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        LogsHandler.saveProgramLogs("convertAndSendFile", e.getLocalizedMessage());
                    }
                }
                if (!this.fileTimeMap.isEmpty()) continue;
                try {
                    signalledKey = this.watchService.take();
                }
                catch (ClosedWatchServiceException e1) {
                    e1.printStackTrace();
                }
                catch (InterruptedException e1) {
                    e1.printStackTrace();
                }
            }
            try {
                List list = signalledKey.pollEvents();
                signalledKey.reset();
                Iterator iterator = list.iterator();
                while (true) {
                    String path;
                    Path context;
                    if (!iterator.hasNext()) continue block10;
                    WatchEvent e = (WatchEvent)iterator.next();
                    String radarName = "";
                    if (e.kind() == StandardWatchEventKind.ENTRY_CREATE) {
                        context = (Path)e.context();
                        if (context.toString().startsWith(".")) continue;
                        path = "";
                        path = this.pathMap.get(signalledKey).getDir();
                        radarName = this.pathMap.get(signalledKey).getRadarName();
                        if (!path.endsWith("/")) {
                            path = String.valueOf(path) + "/";
                        }
                        path = String.valueOf(path) + context.toString();
                        this.msgl.showMessage(String.valueOf(radarName) + ": new file: " + path, true);
                        this.fileTimeMap.put(path, System.currentTimeMillis());
                        continue;
                    }
                    if (e.kind() == StandardWatchEventKind.ENTRY_MODIFY) {
                        context = (Path)e.context();
                        if (context.toString().startsWith(".")) continue;
                        path = "";
                        path = this.pathMap.get(signalledKey).getDir();
                        radarName = this.pathMap.get(signalledKey).getRadarName();
                        if (!path.endsWith("/")) {
                            path = String.valueOf(path) + "/";
                        }
                        path = String.valueOf(path) + context.toString();
                        this.fileTimeMap.put(path, System.currentTimeMillis());
                        continue;
                    }
                    if (e.kind() != StandardWatchEventKind.OVERFLOW) continue;
                    System.out.println("OVERFLOW: more changes happened than we could retreive");
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

