/*
 * Decompiled with CFR 0.152.
 */
package pl.imgw.odimH5.util;

import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;

public class CommandLineArgsParser {
    public static final String FILE_OBJECT_OPTION = "f";
    public static final String PLATFORM_OPTION = "p";
    public static final String INPUT_FILE_OPTION = "i";
    public static final String OUTPUT_FILE_OPTION = "o";
    public static final String VERBOSE_OPTION = "v";
    public static final String HELP_OPTION = "h";
    public static final String CONTINOUOS_OPTION = "c";
    public static final String ADDRESS_OPTION = "a";
    public static final String SENDER_OPTION = "s";
    public static final String RADAR_OPTION = "r";
    private static final String START_COMMAND = "java -jar odimH5.jar -i <descriptor_file : data_file> -f <object> -p <platform> -o <output_file> -c <file_format> -a <address> -s <sender> -r <radar> [-v] [-h]";
    private static final String FILE_OBJECT_DESCRIPTION = "ODIM_H5 file object option\n<arg>\n PVOL: polar volume\n CVOL: carthesian volume\n SCAN polar scan\nRAY: single polar ray\n AZIM: azimuthal object\n IMAGE: 2-D cartesian image\nCOMP: cartesian composite image(s)\n XSEC: 2-D vertical cross section(s)\nVP: 1-D vertical profile\n PIC: embedded graphical image";
    private static final String PLATFORM_DESCRIPTION = "processing software option\n<arg>\n CASTOR: M\u00e9t\u00e9o France\u2019s system\n EDGE: EEC Edge\nFROG: Gamic FROG, MURAN...\n IRIS: Sigmet IRIS\n NORDRAD: NORDRAD\nRADARNET: UKMO\u2019s system\n RAINBOW: Gematronik Rainbow";
    private static final String INPUT_FILE_DESCRIPTION = "input file option\n<arg>\n input file's path";
    private static final String OUTPUT_FILE_DESCRIPTION = "output file option\n<arg>\n output file's path";
    private static final String CONTINOUOS_DESCRIPTION = "Baltrad feeder continuous work mode\n";
    private static final String ADDRESS_DESCRIPTION = "send file to http server\n<arg>\n server address\n";
    private static final String SENDER_DESCRIPTION = "sender\n<arg>\n sender name\n";
    private static final String RADAR_DESCRIPTION = "radar name\n<arg>\n radar name\n";
    private static final String VERBOSE_DESCRIPTION = "verbose mode option";
    private static final String HELP_DESCRIPTION = "print this message";
    private static Options options = null;
    private static CommandLine cmd = null;

    static {
        options = new Options();
        OptionBuilder.withArgName((String)FILE_OBJECT_OPTION);
        OptionBuilder.withArgName((String)"arg");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)FILE_OBJECT_DESCRIPTION);
        Option file_object = OptionBuilder.create((String)FILE_OBJECT_OPTION);
        OptionBuilder.withArgName((String)PLATFORM_OPTION);
        OptionBuilder.withArgName((String)"arg");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)PLATFORM_DESCRIPTION);
        Option platform = OptionBuilder.create((String)PLATFORM_OPTION);
        OptionBuilder.withArgName((String)INPUT_FILE_OPTION);
        OptionBuilder.withArgName((String)"arg");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)INPUT_FILE_DESCRIPTION);
        Option input_file = OptionBuilder.create((String)INPUT_FILE_OPTION);
        OptionBuilder.withArgName((String)OUTPUT_FILE_OPTION);
        OptionBuilder.withArgName((String)"arg");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)OUTPUT_FILE_DESCRIPTION);
        Option output_file = OptionBuilder.create((String)OUTPUT_FILE_OPTION);
        OptionBuilder.withArgName((String)CONTINOUOS_OPTION);
        OptionBuilder.withDescription((String)CONTINOUOS_DESCRIPTION);
        Option continuous = OptionBuilder.create((String)CONTINOUOS_OPTION);
        OptionBuilder.withArgName((String)ADDRESS_OPTION);
        OptionBuilder.withArgName((String)"arg");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)ADDRESS_DESCRIPTION);
        Option address = OptionBuilder.create((String)ADDRESS_OPTION);
        OptionBuilder.withArgName((String)SENDER_OPTION);
        OptionBuilder.withArgName((String)"arg");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)SENDER_DESCRIPTION);
        Option sender = OptionBuilder.create((String)SENDER_OPTION);
        OptionBuilder.withArgName((String)RADAR_OPTION);
        OptionBuilder.withArgName((String)"arg");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription((String)RADAR_DESCRIPTION);
        Option radar = OptionBuilder.create((String)RADAR_OPTION);
        OptionBuilder.withArgName((String)VERBOSE_OPTION);
        OptionBuilder.withDescription((String)VERBOSE_DESCRIPTION);
        Option verbose = OptionBuilder.create((String)VERBOSE_OPTION);
        OptionBuilder.withArgName((String)HELP_OPTION);
        OptionBuilder.withDescription((String)HELP_DESCRIPTION);
        Option help = OptionBuilder.create((String)HELP_OPTION);
        options.addOption(file_object);
        options.addOption(platform);
        options.addOption(input_file);
        options.addOption(output_file);
        options.addOption(continuous);
        options.addOption(address);
        options.addOption(sender);
        options.addOption(radar);
        options.addOption(verbose);
        options.addOption(help);
    }

    public void parseCommandLineArgs(String[] args) {
        PosixParser parser = new PosixParser();
        try {
            cmd = parser.parse(options, args);
        }
        catch (ParseException e) {
            this.printHelpAndExit(1, START_COMMAND, options);
        }
        if (cmd.hasOption(HELP_OPTION)) {
            this.printHelpAndExit(1, HELP_OPTION, options);
        }
        if (!(cmd.hasOption(INPUT_FILE_OPTION) && cmd.hasOption(OUTPUT_FILE_OPTION) || cmd.hasOption(INPUT_FILE_OPTION) && cmd.hasOption(FILE_OBJECT_OPTION) && cmd.hasOption(PLATFORM_OPTION) || cmd.hasOption(CONTINOUOS_OPTION) || cmd.hasOption(ADDRESS_OPTION) && cmd.hasOption(SENDER_OPTION) && cmd.hasOption(RADAR_OPTION))) {
            this.printHelpAndExit(1, START_COMMAND, options);
        }
    }

    public boolean hasArgument(String option) {
        return cmd.hasOption(option);
    }

    public String getArgumentValue(String option) {
        return cmd.getOptionValue(option);
    }

    public void printHelpAndExit(int exitCode, String startCommand, Options options) {
        System.out.println("OdimH5 version 2.14a. Converter software for OPERA Data Information Model\n");
        HelpFormatter helpFormatter = new HelpFormatter();
        helpFormatter.printHelp(startCommand, options);
        System.exit(exitCode);
    }
}

