/*
 * Decompiled with CFR 0.152.
 */
package pl.imgw.odimH5.model.rainbow;

import com.jcraft.jzlib.ZStream;
import com.jhlabs.map.proj.Projection;
import com.jhlabs.map.proj.ProjectionException;
import com.jhlabs.map.proj.ProjectionFactory;
import java.awt.geom.Point2D;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.ObjectOutputStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.TimeZone;
import org.apache.xerces.parsers.DOMParser;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.InputSource;
import pl.imgw.odimH5.model.HDF5Model;
import pl.imgw.odimH5.util.DataBufferContainer;
import pl.imgw.odimH5.util.MessageLogger;

public class RainbowModel {
    public final int PRODUCT = 0;
    public final int VOLUME = 1;
    protected final String H5_ROOT = "/";
    protected final String H5_GROUP = "group";
    protected final String H5_OBJECT_NAME = "name";
    protected final String H5_OBJECT_CLASS = "class";
    protected final String H5_WHAT = "what";
    protected final String H5_WHERE = "where";
    protected final String H5_HOW = "how";
    protected final String H5_ATTRIBUTE = "attribute";
    protected final String H5_DATASET = "dataset";
    protected final String H5_DATASET_N = "dataset1";
    protected final String H5_DATA = "data";
    protected final String H5_DATA_1 = "data1";
    protected final String H5_STRING = "string";
    protected final String H5_INTEGER = "integer";
    protected final String H5_DATA_SIZE = "32";
    protected final String H5_LONG = "long";
    protected final String H5_DOUBLE = "double";
    protected final String H5_SEQUENCE = "sequence";
    protected final String IMAGE_VER = "1.2";
    protected final String H5_DATA_CHUNK = "20";
    protected final String H5_GZIP_LEVEL = "6";
    protected final String EARTH_RAD = "6371000";
    protected final String TYPE_DBZ = "dBZ";
    protected final String TYPE_DBR = "dBR";
    protected final String TYPE_DBA = "dBA";
    protected final String TYPE_V = "V";
    protected final String TYPE_H = "Height";
    protected final String UPHIDP = "uPhiDP";
    protected final String DBZ = "dBZ";
    protected final String QNT_TH = "TH";
    protected final String QNT_RATE = "RATE";
    protected final String QNT_ACRR = "ACRR";
    protected final String QNT_VRAD = "VRAD";
    protected final String QNT_H = "HGHT";
    public final String VERSION = "H5rad 2.0";
    protected final String RAINBOW_SYSTEM = "GEMA";
    protected final String RAINBOW_SOFTWARE = "RAINBOW";
    protected final String RAINBOW_SCAN = "SCAN";
    public final String IMAGE = "IMAGE";
    public final String PVOL = "PVOL";
    public final String VP = "VP";
    public final String RHI = "RHI";
    protected final double FIRST_VALUE = 1.0;
    protected final double RAINBOW_NO_DATA = 255.0;
    protected final double RAINBOW_UNDETECT = 0.0;
    private MessageLogger msgl;
    HDF5Model hdf;

    public MessageLogger getMessageLogger() {
        return this.msgl;
    }

    public void setMessageLogger(MessageLogger msgl) {
        this.msgl = msgl;
    }

    public HDF5Model getHDFModel() {
        return this.hdf;
    }

    public void setHDFModel(HDF5Model proc) {
        this.hdf = proc;
    }

    public byte[] getRAINBOWMetadata(byte[] file_buf, int format, boolean verbose) {
        String END_XML = "";
        if (format == 1) {
            END_XML = "</volume>";
        } else if (format == 0) {
            END_XML = "</product>";
        }
        int len = END_XML.length();
        byte[] end_xml_buf = new byte[len + 1];
        byte[] hdr_buf = null;
        String end_xml_seq = "";
        int offset = 0;
        int end_xml = 0;
        try {
            int i;
            while (offset < file_buf.length) {
                end_xml_buf[len] = file_buf[offset];
                i = 1;
                while (i <= len) {
                    end_xml_buf[i - 1] = end_xml_buf[i];
                    ++i;
                }
                i = 0;
                while (i < len) {
                    end_xml_seq = String.valueOf(end_xml_seq) + (char)end_xml_buf[i];
                    ++i;
                }
                if (end_xml_seq.matches(END_XML)) {
                    end_xml = offset;
                }
                end_xml_seq = "";
                ++offset;
            }
            hdr_buf = new byte[++end_xml];
            i = 0;
            while (i < end_xml) {
                hdr_buf[i] = file_buf[i];
                ++i;
            }
            this.msgl.showMessage("Reading RAINBOW metadata header", verbose);
        }
        catch (Exception e) {
            this.msgl.showMessage("Error while reading RAINBOW metadata header", verbose);
        }
        return hdr_buf;
    }

    public byte[] getRAINBOWData_nieuzywane(byte[] file_buf, boolean verbose) {
        String START_BIN = "<BLOB";
        String END_BIN = "</BLOB>";
        byte[] start_bin_buf = new byte[6];
        byte[] end_bin_buf = new byte[8];
        byte[] data_buf = null;
        String start_bin_seq = "";
        String end_bin_seq = "";
        int offset = 0;
        int start_bin = 0;
        int end_bin = 0;
        try {
            while (offset < file_buf.length) {
                start_bin_buf[5] = file_buf[offset];
                int i = 1;
                while (i <= 5) {
                    start_bin_buf[i - 1] = start_bin_buf[i];
                    ++i;
                }
                i = 0;
                while (i < 5) {
                    start_bin_seq = String.valueOf(start_bin_seq) + (char)start_bin_buf[i];
                    ++i;
                }
                if (start_bin_seq.matches("<BLOB")) {
                    while ((char)file_buf[offset] != '>') {
                        ++offset;
                    }
                    start_bin = offset;
                }
                end_bin_buf[7] = file_buf[offset];
                i = 1;
                while (i <= 7) {
                    end_bin_buf[i - 1] = end_bin_buf[i];
                    ++i;
                }
                i = 0;
                while (i < 7) {
                    end_bin_seq = String.valueOf(end_bin_seq) + (char)end_bin_buf[i];
                    ++i;
                }
                if (end_bin_seq.matches("</BLOB>")) {
                    end_bin = offset;
                    break;
                }
                start_bin_seq = "";
                end_bin_seq = "";
                ++offset;
            }
            int bin_count = 0;
            data_buf = new byte[(end_bin -= 6) - (start_bin += 6)];
            int i = start_bin;
            while (i < end_bin) {
                data_buf[bin_count] = file_buf[i];
                ++bin_count;
                ++i;
            }
            this.msgl.showMessage("Reading RAINBOW data section", verbose);
        }
        catch (Exception e) {
            this.msgl.showMessage("Error while reading RAINBOW data section", verbose);
        }
        return data_buf;
    }

    public DataBufferContainer getRAINBOWMaskSection_nieuzywana(byte[] file_buf, boolean verbose) {
        DataBufferContainer dataBuff = new DataBufferContainer();
        int buff_len = 0;
        String START_BIN = "<BLOB";
        String END_BIN = "</BLOB>";
        byte[] sec_start = new byte[6];
        byte[] sec_end = new byte[8];
        byte[] sec_buf = null;
        String start_seq = "";
        String end_seq = "";
        int offset = 0;
        int start_pos = 0;
        int end_pos = 0;
        int start_blob_count = 0;
        int end_blob_count = 0;
        try {
            while (offset < file_buf.length) {
                sec_start[5] = file_buf[offset];
                int i = 1;
                while (i <= 5) {
                    sec_start[i - 1] = sec_start[i];
                    ++i;
                }
                i = 0;
                while (i < 5) {
                    start_seq = String.valueOf(start_seq) + (char)sec_start[i];
                    ++i;
                }
                if (start_seq.matches("<BLOB") && ++start_blob_count > 1) {
                    while ((char)file_buf[offset] != '>') {
                        ++offset;
                    }
                    start_pos = offset;
                }
                sec_end[7] = file_buf[offset];
                i = 1;
                while (i <= 7) {
                    sec_end[i - 1] = sec_end[i];
                    ++i;
                }
                i = 0;
                while (i < 7) {
                    end_seq = String.valueOf(end_seq) + (char)sec_end[i];
                    ++i;
                }
                if (end_seq.matches("</BLOB>") && ++end_blob_count > 1) {
                    end_pos = offset;
                    break;
                }
                start_seq = "";
                end_seq = "";
                ++offset;
            }
            byte[] mask_byte = new byte[4];
            int i = 0;
            while (i < 4) {
                mask_byte[i] = file_buf[start_pos + i + 2];
                ++i;
            }
            int mask_count = 0;
            sec_buf = new byte[(end_pos -= 6) - (start_pos += 6)];
            int i2 = start_pos;
            while (i2 < end_pos) {
                sec_buf[mask_count] = file_buf[i2];
                ++mask_count;
                ++i2;
            }
            buff_len = this.byteArray2Int(mask_byte);
            dataBuff.setDataBufferLength(buff_len);
            dataBuff.setDataBuffer(sec_buf);
            this.msgl.showMessage("Reading RAINBOW mask section", verbose);
        }
        catch (Exception e) {
            this.msgl.showMessage("Error while reading RAINBOW mask section", verbose);
        }
        return dataBuff;
    }

    public int byteArray2Int(byte[] b) {
        int value = 0;
        int i = 0;
        while (i < 4) {
            int shift = (3 - i) * 8;
            value += (b[i] & 0xFF) << shift;
            ++i;
        }
        return value;
    }

    public Document parseRAINBOWMetadataBuffer(byte[] hdrBuff, boolean verbose) {
        Document doc = null;
        try {
            ByteArrayInputStream bis = new ByteArrayInputStream(hdrBuff);
            DOMParser parser = new DOMParser();
            InputSource is = new InputSource(bis);
            parser.parse(is);
            doc = parser.getDocument();
            this.msgl.showMessage("Parsing RAINBOW metadata buffer", verbose);
        }
        catch (Exception e) {
            this.msgl.showMessage("Error while parsing RAINBOW metadata buffer: " + e.getMessage(), verbose);
        }
        return doc;
    }

    public Element makeAttr(String attributeName, String attributeValue, Document outputDoc, String type) {
        Element attribute = outputDoc.createElement("attribute");
        attribute.setAttribute("name", attributeName);
        if (!type.isEmpty()) {
            attribute.setAttribute("class", type);
        }
        Text text = outputDoc.createTextNode(attributeValue);
        attribute.appendChild(text);
        return attribute;
    }

    public Element makeTag(String tagName, String value, Document od) {
        Element tag = od.createElement(tagName);
        Text text = od.createTextNode(value);
        tag.appendChild(text);
        return tag;
    }

    public NodeList getRAINBOWNodesByName(Document doc, String nodeTagName, boolean verbose) {
        NodeList nodeList = null;
        nodeList = doc.getElementsByTagName(nodeTagName);
        if (nodeList.getLength() == 0) {
            this.msgl.showMessage("Metadata header element not found: " + nodeTagName, verbose);
        }
        return nodeList;
    }

    public String getRAINBOWMetadataElement(NodeList nodeList, String argName, boolean verbose) {
        String value = "";
        Node node = null;
        Node attrNode = null;
        NamedNodeMap nodeMap = null;
        int i = 0;
        while (i < nodeList.getLength()) {
            node = nodeList.item(i);
            if (!argName.trim().isEmpty()) {
                nodeMap = node.getAttributes();
                int j = 0;
                while (j < nodeMap.getLength()) {
                    attrNode = nodeMap.item(j);
                    if (attrNode.getNodeName().equals(argName)) {
                        value = attrNode.getNodeValue();
                    }
                    ++j;
                }
            } else {
                value = node.getFirstChild().getNodeValue();
            }
            ++i;
        }
        if (value.trim().isEmpty()) {
            this.msgl.showMessage("Invalid metadata header element", verbose);
        }
        return value;
    }

    public static String getValueByName(Node node, String elemName, String atrName) {
        String value = null;
        short type = node.getNodeType();
        if (type == 9) {
            value = RainbowModel.getValueByName(((Document)node).getDocumentElement(), elemName, atrName);
        }
        if (type == 1) {
            int i;
            if (atrName != null && node.getNodeName().equals(elemName)) {
                NamedNodeMap attrs = node.getAttributes();
                i = 0;
                while (i < attrs.getLength()) {
                    value = RainbowModel.getValueByName(attrs.item(i), elemName, atrName);
                    if (value != null) {
                        return value;
                    }
                    ++i;
                }
            } else if (atrName == null && node.getNodeName().equals(elemName) && node.hasChildNodes()) {
                return node.getFirstChild().getNodeValue();
            }
            if (node.hasChildNodes()) {
                NodeList children = node.getChildNodes();
                i = 0;
                while (i < children.getLength()) {
                    value = RainbowModel.getValueByName(children.item(i), elemName, atrName);
                    if (value != null) {
                        return value;
                    }
                    ++i;
                }
            }
        } else if (type == 2 && node.getNodeName().equals(atrName)) {
            value = node.getNodeValue();
            return value;
        }
        return value;
    }

    public String parseRAINBOWDate(String rainbowDate, boolean verbose) {
        String h5Date = null;
        try {
            SimpleDateFormat in = new SimpleDateFormat("yyyy-MM-dd");
            SimpleDateFormat out = new SimpleDateFormat("yyyyMMdd");
            Date date = (Date)in.parseObject(rainbowDate);
            h5Date = out.format((Object)date);
        }
        catch (ParseException e) {
            this.msgl.showMessage("Error while parsing date: " + e.getMessage(), verbose);
        }
        return h5Date;
    }

    public String parseRAINBOWTime(String rainbowTime, int shift, boolean verbose) {
        String h5Time = null;
        try {
            Calendar cal = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
            SimpleDateFormat in_out = new SimpleDateFormat("HHmmss");
            Date date = (Date)in_out.parseObject(rainbowTime);
            cal.setTime(date);
            cal.add(13, shift);
            date = cal.getTime();
            h5Time = in_out.format((Object)date);
        }
        catch (ParseException e) {
            this.msgl.showMessage("Error while parsing date: " + e.getMessage(), verbose);
        }
        return h5Time;
    }

    public String parseRAINBOWTime(String rainbowTime, boolean verbose) {
        String h5Time = null;
        try {
            SimpleDateFormat in = new SimpleDateFormat("HH:mm:ss");
            SimpleDateFormat out = new SimpleDateFormat("HHmmss");
            Date date = (Date)in.parseObject(rainbowTime);
            h5Time = out.format((Object)date);
        }
        catch (ParseException e) {
            this.msgl.showMessage("Error while parsing date: " + e.getMessage(), verbose);
        }
        return h5Time;
    }

    public String convertRAINBOWDate2Epoch(String rainbowDate, String rainbowTime, boolean verbose) {
        String epoch = null;
        Calendar cal = Calendar.getInstance();
        try {
            SimpleDateFormat in = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            String dateTime = String.valueOf(rainbowDate) + " " + rainbowTime;
            Date date = (Date)in.parseObject(dateTime);
            cal.setTime(date);
            long time = cal.getTimeInMillis();
            epoch = String.valueOf(time);
        }
        catch (ParseException e) {
            this.msgl.showMessage("Error while parsing date: " + e.getMessage(), verbose);
        }
        return epoch;
    }

    public String convertRAINBOWParam(String param) {
        String outputParam = param.replaceAll("@", "");
        return outputParam.replace(" to ", ",");
    }

    public String convertKMtoM(String param) {
        String temp = "";
        double a = 0.0;
        int pos = 0;
        if (param.contains(",")) {
            pos = param.indexOf(",");
            temp = param.substring(0, pos++);
            a = Double.parseDouble(temp);
            temp = String.valueOf(String.valueOf(a * 1000.0)) + ",";
        }
        a = Double.parseDouble(param.substring(pos));
        temp = String.valueOf(temp) + String.valueOf(a * 1000.0);
        System.out.println(temp);
        return temp;
    }

    public String convertTimeInterval(String interval) {
        int i = 0;
        i = interval.indexOf("@", i) + 1;
        int minutes = Integer.parseInt(interval.substring(i++, interval.indexOf(" d"))) * 24 * 60;
        i = interval.indexOf("@", i) + 1;
        minutes += Integer.parseInt(interval.substring(i++, interval.indexOf(" h"))) * 60;
        i = interval.indexOf("@", i) + 1;
        return String.valueOf(minutes += Integer.parseInt(interval.substring(i, interval.indexOf(" m"))));
    }

    public String getRAINBOWQuantity(String type) {
        String quantity = null;
        if (type.equals("dBZ")) {
            quantity = "DBZH";
        }
        return quantity;
    }

    public String getRAINBOWGain(String min, String max, int res) {
        String gain = null;
        double minVal = 0.0;
        double maxVal = 0.0;
        try {
            minVal = Double.parseDouble(min);
            maxVal = Double.parseDouble(max);
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
        }
        double gainVal = (Math.abs(minVal) + Math.abs(maxVal)) / (Math.pow(2.0, res) - 2.0);
        gain = String.valueOf(RainbowModel.round(gainVal, 6));
        return gain;
    }

    public String getRAINBOWOffset(String min, String step) {
        double offset = 0.0;
        double gain = 0.0;
        try {
            offset = Double.parseDouble(min);
            gain = Double.parseDouble(step);
        }
        catch (NumberFormatException e) {
            System.out.println(e.getLocalizedMessage());
            return null;
        }
        return String.valueOf(offset -= gain * 1.0);
    }

    public String parseRAINBOWProjection(String lon0, String lat0, String type, String ellps, String radius) {
        String projection = null;
        projection = "+proj=" + type + " +lon_0=" + lon0 + " +lat_0=" + lat0 + " " + ellps + " +a=" + radius;
        return projection;
    }

    public Projection initializeProjection(String projectionString, boolean verbose) {
        Projection proj = null;
        String[] projectionParms = projectionString.split(" ");
        try {
            proj = ProjectionFactory.fromPROJ4Specification((String[])projectionParms);
            proj.initialize();
        }
        catch (ProjectionException e) {
            this.msgl.showMessage("Error while initializing projection: " + e.getMessage(), verbose);
        }
        return proj;
    }

    public Point2D.Double getRAINBOWXYSize(Projection proj, String lon_UL, String lat_UL, String lon_LR, String lat_LR, String xSize, String ySize) {
        Point2D.Double in = new Point2D.Double();
        Point2D.Double out = new Point2D.Double();
        Point2D.Double size = new Point2D.Double();
        double lon_ul = Double.parseDouble(lon_UL);
        double lat_ul = Double.parseDouble(lat_UL);
        double lon_lr = Double.parseDouble(lon_LR);
        double lat_lr = Double.parseDouble(lat_LR);
        int xsize = Integer.parseInt(xSize);
        int ysize = Integer.parseInt(ySize);
        in.setLocation(lon_ul, lat_ul);
        proj.transform(in, out);
        size.setLocation(out.getX(), out.getY());
        in.setLocation(lon_lr, lat_lr);
        proj.transform(in, out);
        size.setLocation((-size.getX() + out.getX()) / (double)xsize, (size.getY() - out.getY()) / (double)ysize);
        return size;
    }

    public int[][] inflate2DRAINBOWDataSection(byte[] input_buf, int rays, int bins, boolean verbose) {
        this.msgl.showMessage("Inflating RAINBOW 2D data section", verbose);
        int[][] output_buf = new int[rays][bins];
        int len = rays * bins;
        byte[] byte_buf = new byte[len];
        ZStream defStream = new ZStream();
        defStream.next_in = input_buf;
        defStream.next_in_index = 0;
        defStream.next_out = byte_buf;
        defStream.next_out_index = 0;
        int err = defStream.inflateInit();
        this.checkErr(defStream, err, "Inflation initialization error", verbose);
        int a = 0;
        while (defStream.total_out < (long)len && defStream.total_in < (long)input_buf.length) {
            defStream.avail_out = 1;
            defStream.avail_in = 1;
            err = defStream.inflate(0);
            if (err == 1) break;
            ++a;
            this.checkErr(defStream, err, "Inflation error", verbose);
        }
        err = defStream.inflateEnd();
        this.checkErr(defStream, err, "Inflation end error", verbose);
        int count = 0;
        int x = 0;
        while (x < rays) {
            int y = 0;
            while (y < bins) {
                count = y * rays + x;
                output_buf[x][y] = byte_buf[count] & 0xFF;
                ++y;
            }
            ++x;
        }
        return output_buf;
    }

    public byte[] inflate1DRAINBOWDataSection(byte[] dataBuff, int length, boolean verbose) {
        this.msgl.showMessage("Inflating RAINBOW 1D data section", verbose);
        byte[] output_buf = new byte[length];
        ZStream defStream = new ZStream();
        defStream.next_in = dataBuff;
        defStream.next_in_index = 0;
        defStream.next_out = output_buf;
        defStream.next_out_index = 0;
        int err = defStream.inflateInit();
        this.checkErr(defStream, err, "Inflation initialization error", verbose);
        while (defStream.total_out < (long)length && defStream.total_in < (long)dataBuff.length) {
            defStream.avail_out = 1;
            defStream.avail_in = 1;
            err = defStream.inflate(0);
            if (err == 1) break;
            this.checkErr(defStream, err, "Inflation error", verbose);
        }
        err = defStream.inflateEnd();
        this.checkErr(defStream, err, "Inflation end error", verbose);
        return output_buf;
    }

    public void checkErr(ZStream z, int err, String msg, boolean verbose) {
        if (err != 0) {
            if (z.msg != null) {
                msg = String.valueOf(msg) + ": " + z.msg;
            }
            this.msgl.showMessage(String.valueOf(err) + " " + msg, verbose);
            System.exit(0);
        }
    }

    /*
     * Exception decompiling
     */
    public HashMap<Integer, DataBufferContainer> getAllRainbowDataBlobs(byte[] fileBuff, boolean verbose) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public DataBufferContainer getRainbowDataSection(byte[] fileBuff, int blobNumber, int firstBlob, boolean verbose) {
        DataBufferContainer dbc = new DataBufferContainer();
        String START_BIN = "<BLOB";
        String END_BIN = "</BLOB>";
        byte[] start_bin_buf = new byte[6];
        byte[] end_bin_buf = new byte[8];
        byte[] data_buf = null;
        String start_bin_seq = "";
        String end_bin_seq = "";
        int offset = 0;
        int start_bin = 0;
        int end_bin = 0;
        int current = firstBlob - 1;
        try {
            while (offset < fileBuff.length) {
                start_bin_buf[5] = fileBuff[offset];
                int i = 1;
                while (i <= 5) {
                    start_bin_buf[i - 1] = start_bin_buf[i];
                    ++i;
                }
                i = 0;
                while (i < 5) {
                    start_bin_seq = String.valueOf(start_bin_seq) + (char)start_bin_buf[i];
                    ++i;
                }
                if (start_bin_seq.matches("<BLOB")) {
                    while ((char)fileBuff[offset] != '>') {
                        ++offset;
                    }
                    start_bin = offset;
                    ++current;
                }
                end_bin_buf[7] = fileBuff[offset];
                i = 1;
                while (i <= 7) {
                    end_bin_buf[i - 1] = end_bin_buf[i];
                    ++i;
                }
                i = 0;
                while (i < 7) {
                    end_bin_seq = String.valueOf(end_bin_seq) + (char)end_bin_buf[i];
                    ++i;
                }
                if (end_bin_seq.matches("</BLOB>") && current == blobNumber) {
                    end_bin = offset;
                    break;
                }
                start_bin_seq = "";
                end_bin_seq = "";
                ++offset;
            }
            byte[] data_byte = new byte[4];
            int i = 0;
            while (i < 4) {
                data_byte[i] = fileBuff[start_bin + i + 2];
                ++i;
            }
            int bin_count = 0;
            data_buf = new byte[(end_bin -= 6) - (start_bin += 6)];
            int i2 = start_bin;
            while (i2 < end_bin) {
                data_buf[bin_count] = fileBuff[i2];
                ++bin_count;
                ++i2;
            }
            int buffLen = this.byteArray2Int(data_byte);
            dbc.setDataBuffer(data_buf);
            dbc.setDataBufferLength(buffLen);
            this.msgl.showMessage("Reading RAINBOW data section from BLOB " + blobNumber, verbose);
        }
        catch (Exception e) {
            this.msgl.showMessage("Error while reading RAINBOW data section from BLOB " + blobNumber, verbose);
        }
        return dbc;
    }

    public int[][] createRAINBOWMask(int[][] data_buf, int width, int height, byte[] mask_buf, int depth, boolean verbose) {
        int count = 0;
        int value = 0;
        int _byte = 0;
        int bit = 0;
        byte thisbyte = 0;
        try {
            int x = 0;
            while (x < height) {
                int y = 0;
                while (y < width) {
                    value = 0;
                    _byte = count * depth / 8;
                    thisbyte = mask_buf[_byte];
                    bit = 7 - count * depth % 8;
                    value = thisbyte >> bit & 1;
                    if (value != 0) {
                        data_buf[y][x] = 255;
                    }
                    ++count;
                    ++y;
                }
                ++x;
            }
        }
        catch (Exception e) {
            this.msgl.showMessage("Failed to create range mask", verbose);
        }
        return data_buf;
    }

    public void writeRAINBOWData(int[][] dataBuff, String fileName, boolean verbose) {
        this.msgl.showMessage("Writing data to file: " + fileName, verbose);
        try {
            FileOutputStream fos = new FileOutputStream(new File(fileName));
            ObjectOutputStream oos = new ObjectOutputStream(fos);
            oos.writeObject(dataBuff);
            oos.flush();
            oos.close();
        }
        catch (Exception e) {
            this.msgl.showMessage("Failed to write data file: " + e.getMessage(), verbose);
        }
    }

    public static double round(double d, int ic) {
        double dex = Math.pow(10.0, ic);
        d *= dex;
        d = Math.round(d);
        return d /= dex;
    }

    public static int getMin(int a, int b) {
        if (a > b) {
            return b;
        }
        return a;
    }
}

