/*
 * Decompiled with CFR 0.152.
 */
package pl.imgw.odimH5.model.rainbow;

import java.io.File;
import java.util.HashMap;
import ncsa.hdf.hdf5lib.HDF5Constants;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import pl.imgw.odimH5.model.HDF5Model;
import pl.imgw.odimH5.model.rainbow.PVOLSlicesCont;
import pl.imgw.odimH5.model.rainbow.RainbowModel;
import pl.imgw.odimH5.util.DataBufferContainer;
import pl.imgw.odimH5.util.RadarOptions;

public class Rainbow2HDFPVOL {
    private static final String VER51X = "5.1";
    private static final String VER52X = "5.2";
    private static final String VER53X = "5.3";
    private static final String PRODUCT = "SCAN";
    private boolean verbose;
    private RainbowModel rb;
    private RadarOptions[] options;
    private String version;
    private String filePrefix = "";
    private String outputFileName = "";
    private String date = "";
    private String time = "";
    private String rangestep;
    private String source = "";
    private String radarFullName = "";
    private int shift = 0;
    private int size = 0;
    private String nray_new = "";
    private String[] nray_org;
    public boolean correct = false;
    private HashMap<String, String> whatG;
    private HashMap<String, String> howG;
    private HashMap<String, String> whereG;
    private HashMap<String, String> qiG;
    private PVOLSlicesCont[] slices;
    private HashMap<Integer, DataBufferContainer> blobs;

    public Rainbow2HDFPVOL(String outputFileName, byte[] fileBuff, boolean verbose, RainbowModel rb, RadarOptions[] options) throws Exception {
        byte[] hdrBuff = rb.getRAINBOWMetadata(fileBuff, rb.VOLUME, verbose);
        Document inputDoc = rb.parseRAINBOWMetadataBuffer(hdrBuff, verbose);
        if (inputDoc == null) {
            return;
        }
        this.verbose = verbose;
        this.rb = rb;
        this.options = options;
        NodeList nodeList = null;
        nodeList = rb.getRAINBOWNodesByName(inputDoc, "volume", verbose);
        this.version = rb.getRAINBOWMetadataElement(nodeList, "version", verbose);
        this.whatG = this.makeWhatGroup(inputDoc);
        if (this.whatG == null) {
            return;
        }
        this.howG = this.makeHowGroup(inputDoc);
        this.whereG = this.makeWhereGroup(inputDoc);
        if (this.whereG == null) {
            return;
        }
        nodeList = rb.getRAINBOWNodesByName(inputDoc, "QI", verbose);
        String isQI = rb.getRAINBOWMetadataElement(nodeList, "", verbose);
        this.qiG = isQI.matches("1") ? this.makeQIGroup(inputDoc) : null;
        NodeList sliceList = inputDoc.getElementsByTagName("slice");
        this.size = sliceList.getLength();
        nodeList = rb.getRAINBOWNodesByName(inputDoc, "antspeed", verbose);
        double antSpeed = 1.0;
        try {
            antSpeed = Double.parseDouble(rb.getRAINBOWMetadataElement(nodeList, "", verbose));
        }
        catch (NumberFormatException e) {
            System.out.println("<antspeed> is missing or is not a number");
        }
        this.shift = (int)(360.0 / antSpeed);
        nodeList = rb.getRAINBOWNodesByName(inputDoc, "rangestep", verbose);
        this.rangestep = rb.getRAINBOWMetadataElement(nodeList, "", verbose);
        try {
            this.rangestep = String.valueOf(Double.parseDouble(this.rangestep) * 1000.0);
        }
        catch (NumberFormatException e) {
            System.out.println("<rangestep> is not a number");
            return;
        }
        this.blobs = rb.getAllRainbowDataBlobs(fileBuff, verbose);
        if (this.blobs.size() == 0) {
            return;
        }
        this.slices = this.makeSlices(sliceList);
        if (outputFileName.isEmpty()) {
            this.outputFileName = String.valueOf(this.whatG.get("date")) + this.whatG.get("time") + ".h5";
            if (this.filePrefix != null && !this.filePrefix.isEmpty()) {
                this.outputFileName = String.valueOf(this.filePrefix) + this.outputFileName;
            }
        } else {
            this.outputFileName = outputFileName;
        }
        this.correct = true;
    }

    public void makeXML() throws Exception {
        HDF5Model proc = this.rb.getHDFModel();
        Document od = this.rb.hdf.createXMLDocumentObject(this.verbose);
        Comment comment = od.createComment("ODIM_H5 descriptor file, platform: RAINBOW, file object: " + this.rb.PVOL);
        od.appendChild(comment);
        this.rb.getClass();
        Element root = od.createElement("group");
        this.rb.getClass();
        this.rb.getClass();
        root.setAttribute("name", "/");
        od.appendChild(root);
        this.rb.getClass();
        Element what = od.createElement("group");
        this.rb.getClass();
        this.rb.getClass();
        what.setAttribute("name", "what");
        String string = this.rb.PVOL;
        this.rb.getClass();
        what.appendChild(this.rb.makeAttr("object", string, od, "string"));
        String string2 = this.rb.VERSION;
        this.rb.getClass();
        what.appendChild(this.rb.makeAttr("version", string2, od, "string"));
        this.rb.getClass();
        what.appendChild(this.rb.makeAttr("date", this.whatG.get("date"), od, "string"));
        this.rb.getClass();
        what.appendChild(this.rb.makeAttr("time", this.whatG.get("time"), od, "string"));
        this.rb.getClass();
        what.appendChild(this.rb.makeAttr("source", this.whatG.get("source"), od, "string"));
        root.appendChild(what);
        this.rb.getClass();
        Element where = od.createElement("group");
        this.rb.getClass();
        this.rb.getClass();
        where.setAttribute("name", "where");
        this.rb.getClass();
        where.appendChild(this.rb.makeAttr("lon", this.whereG.get("lon"), od, "double"));
        this.rb.getClass();
        where.appendChild(this.rb.makeAttr("lat", this.whereG.get("lat"), od, "double"));
        this.rb.getClass();
        where.appendChild(this.rb.makeAttr("height", this.whereG.get("height"), od, "double"));
        root.appendChild(where);
        this.rb.getClass();
        Element how = od.createElement("group");
        this.rb.getClass();
        this.rb.getClass();
        how.setAttribute("name", "how");
        this.rb.getClass();
        how.appendChild(this.rb.makeAttr("startepochs", this.howG.get("startepochs"), od, "long"));
        this.rb.getClass();
        how.appendChild(this.rb.makeAttr("endepochs", this.howG.get("endepochs"), od, "long"));
        this.rb.getClass();
        this.rb.getClass();
        how.appendChild(this.rb.makeAttr("system", "GEMA", od, "string"));
        this.rb.getClass();
        this.rb.getClass();
        how.appendChild(this.rb.makeAttr("software", "RAINBOW", od, "string"));
        this.rb.getClass();
        how.appendChild(this.rb.makeAttr("sw_version", this.howG.get("sw_version"), od, "string"));
        this.rb.getClass();
        how.appendChild(this.rb.makeAttr("beamwidth", this.howG.get("beamwidth"), od, "double"));
        this.rb.getClass();
        how.appendChild(this.rb.makeAttr("wavelength", this.howG.get("wavelength"), od, "double"));
        root.appendChild(how);
        int i = 0;
        while (i < this.size) {
            PVOLSlicesCont s = this.slices[i];
            this.rb.getClass();
            Element dataset = od.createElement("group");
            this.rb.getClass();
            this.rb.getClass();
            dataset.setAttribute("name", String.valueOf("dataset") + (i + 1));
            this.rb.getClass();
            Element dataset_what = od.createElement("group");
            this.rb.getClass();
            this.rb.getClass();
            dataset_what.setAttribute("name", "what");
            this.rb.getClass();
            this.rb.getClass();
            dataset_what.appendChild(this.rb.makeAttr("product", PRODUCT, od, "string"));
            this.rb.getClass();
            dataset_what.appendChild(this.rb.makeAttr("startdate", s.dsWhat.get("startdate"), od, "string"));
            this.rb.getClass();
            dataset_what.appendChild(this.rb.makeAttr("starttime", s.dsWhat.get("starttime"), od, "string"));
            this.rb.getClass();
            dataset_what.appendChild(this.rb.makeAttr("enddate", s.dsWhat.get("enddate"), od, "string"));
            this.rb.getClass();
            dataset_what.appendChild(this.rb.makeAttr("endtime", s.dsWhat.get("endtime"), od, "string"));
            dataset.appendChild(dataset_what);
            this.rb.getClass();
            Element dataset_where = od.createElement("group");
            this.rb.getClass();
            this.rb.getClass();
            dataset_where.setAttribute("name", "where");
            this.rb.getClass();
            dataset_where.appendChild(this.rb.makeAttr("elangle", s.dsWhere.get("elangle"), od, "double"));
            this.rb.getClass();
            dataset_where.appendChild(this.rb.makeAttr("nbins", s.dsWhere.get("nbins"), od, "long"));
            this.rb.getClass();
            dataset_where.appendChild(this.rb.makeAttr("rstart", s.dsWhere.get("rstart"), od, "double"));
            this.rb.getClass();
            dataset_where.appendChild(this.rb.makeAttr("rscale", s.dsWhere.get("rscale"), od, "double"));
            this.rb.getClass();
            dataset_where.appendChild(this.rb.makeAttr("nrays", s.dsWhere.get("nrays"), od, "long"));
            this.rb.getClass();
            dataset_where.appendChild(this.rb.makeAttr("a1gate", s.dsWhere.get("a1gate"), od, "long"));
            dataset.appendChild(dataset_where);
            this.rb.getClass();
            Element data1 = od.createElement("group");
            this.rb.getClass();
            this.rb.getClass();
            data1.setAttribute("name", String.valueOf("data") + "1");
            this.rb.getClass();
            Element data_what = od.createElement("group");
            this.rb.getClass();
            this.rb.getClass();
            data_what.setAttribute("name", "what");
            String string3 = s.dsdWhat.get("quantity").toUpperCase();
            this.rb.getClass();
            data_what.appendChild(this.rb.makeAttr("quantity", string3, od, "string"));
            this.rb.getClass();
            data_what.appendChild(this.rb.makeAttr("gain", s.dsdWhat.get("gain"), od, "double"));
            this.rb.getClass();
            data_what.appendChild(this.rb.makeAttr("offset", s.dsdWhat.get("offset"), od, "double"));
            this.rb.getClass();
            String string4 = String.valueOf(255.0);
            this.rb.getClass();
            data_what.appendChild(this.rb.makeAttr("nodata", string4, od, "double"));
            String string5 = String.valueOf((double)this.rb.PRODUCT);
            this.rb.getClass();
            data_what.appendChild(this.rb.makeAttr("undetect", string5, od, "double"));
            data1.appendChild(data_what);
            int rays = Integer.parseInt(s.dsWhere.get("nrays"));
            int bins = Integer.parseInt(s.dsWhere.get("nbins"));
            int[][] infDataBuff = this.rb.inflate2DRAINBOWDataSection(s.getDataBuff().getDataBuffer(), bins, Integer.parseInt(this.nray_org[i]), this.verbose);
            infDataBuff = proc.shiftAzimuths(infDataBuff, rays, bins, Integer.parseInt(s.dsWhere.get("a1gate")));
            infDataBuff = proc.transposeArray(infDataBuff, rays, bins);
            this.rb.getClass();
            Element dataset1 = od.createElement("dataset");
            this.rb.getClass();
            this.rb.getClass();
            dataset1.setAttribute("name", "data");
            this.rb.getClass();
            dataset1.setAttribute("data_type", "integer");
            dataset1.setAttribute("data_size", s.dsdData.get("data_size"));
            this.rb.getClass();
            StringBuilder stringBuilder = new StringBuilder(String.valueOf("20")).append("x");
            this.rb.getClass();
            dataset1.setAttribute("chunk", stringBuilder.append("20").toString());
            dataset1.setAttribute("dimensions", String.valueOf(s.dsWhere.get("nrays")) + "x" + s.dsWhere.get("nbins"));
            this.rb.getClass();
            dataset1.setAttribute("gzip_level", "6");
            dataset1.setAttribute("CLASS", this.rb.IMAGE);
            this.rb.getClass();
            dataset1.setAttribute("IMAGE_VERSION", "1.2");
            String dataDir = this.rb.hdf.createDirectory("data", this.verbose);
            StringBuilder stringBuilder2 = new StringBuilder(String.valueOf(dataDir)).append(File.separator);
            this.rb.getClass();
            String dataFileName = stringBuilder2.append("data").append(i + 1).append(".dat").toString();
            Text text = od.createTextNode(dataFileName);
            dataset1.appendChild(text);
            data1.appendChild(dataset1);
            dataset.appendChild(data1);
            root.appendChild(dataset);
            this.rb.writeRAINBOWData(infDataBuff, dataFileName, this.verbose);
            ++i;
        }
        this.rb.hdf.saveXMLFile(od, this.outputFileName, this.verbose);
    }

    public void makeH5() throws Exception {
        HDF5Model proc = this.rb.getHDFModel();
        int file_id = -1;
        int child_group_id = -1;
        file_id = proc.H5Fcreate_wrap(this.outputFileName, HDF5Constants.H5F_ACC_TRUNC, HDF5Constants.H5P_DEFAULT, HDF5Constants.H5P_DEFAULT, this.verbose);
        child_group_id = proc.H5Gcreate_wrap(file_id, "/what", 0, this.verbose);
        this.rb.getClass();
        proc.H5Acreate_any_wrap(child_group_id, "object", "string", this.rb.PVOL, this.verbose);
        this.rb.getClass();
        proc.H5Acreate_any_wrap(child_group_id, "version", "string", this.rb.VERSION, this.verbose);
        this.rb.getClass();
        proc.H5Acreate_any_wrap(child_group_id, "date", "string", this.whatG.get("date"), this.verbose);
        this.rb.getClass();
        proc.H5Acreate_any_wrap(child_group_id, "time", "string", this.whatG.get("time"), this.verbose);
        this.rb.getClass();
        proc.H5Acreate_any_wrap(child_group_id, "source", "string", this.whatG.get("source"), this.verbose);
        proc.H5Gclose_wrap(child_group_id, this.verbose);
        child_group_id = proc.H5Gcreate_wrap(file_id, "/where", 0, this.verbose);
        this.rb.getClass();
        proc.H5Acreate_any_wrap(child_group_id, "lon", "double", this.whereG.get("lon"), this.verbose);
        this.rb.getClass();
        proc.H5Acreate_any_wrap(child_group_id, "lat", "double", this.whereG.get("lat"), this.verbose);
        this.rb.getClass();
        proc.H5Acreate_any_wrap(child_group_id, "height", "double", this.whereG.get("height"), this.verbose);
        proc.H5Gclose_wrap(child_group_id, this.verbose);
        child_group_id = proc.H5Gcreate_wrap(file_id, "/how", 0, this.verbose);
        this.rb.getClass();
        proc.H5Acreate_any_wrap(child_group_id, "startepochs", "long", this.howG.get("startepochs"), this.verbose);
        this.rb.getClass();
        proc.H5Acreate_any_wrap(child_group_id, "endepochs", "long", this.howG.get("endepochs"), this.verbose);
        this.rb.getClass();
        this.rb.getClass();
        proc.H5Acreate_any_wrap(child_group_id, "system", "string", "GEMA", this.verbose);
        this.rb.getClass();
        this.rb.getClass();
        proc.H5Acreate_any_wrap(child_group_id, "software", "string", "RAINBOW", this.verbose);
        this.rb.getClass();
        proc.H5Acreate_any_wrap(child_group_id, "sw_version", "string", this.howG.get("sw_version"), this.verbose);
        this.rb.getClass();
        proc.H5Acreate_any_wrap(child_group_id, "beamwidth", "double", this.howG.get("beamwidth"), this.verbose);
        this.rb.getClass();
        proc.H5Acreate_any_wrap(child_group_id, "wavelength", "double", this.howG.get("wavelength"), this.verbose);
        if (this.qiG != null) {
            this.makeQIfields(proc, child_group_id);
        }
        proc.H5Gclose_wrap(child_group_id, this.verbose);
        int i = 0;
        while (i < this.size) {
            PVOLSlicesCont s = this.slices[i];
            int grandchild_group_id = -1;
            child_group_id = proc.H5Gcreate_wrap(file_id, "/dataset" + (i + 1), 0, this.verbose);
            grandchild_group_id = proc.H5Gcreate_wrap(child_group_id, "what", 0, this.verbose);
            this.rb.getClass();
            this.rb.getClass();
            proc.H5Acreate_any_wrap(grandchild_group_id, "product", "string", PRODUCT, this.verbose);
            this.rb.getClass();
            proc.H5Acreate_any_wrap(grandchild_group_id, "startdate", "string", s.dsWhat.get("startdate"), this.verbose);
            this.rb.getClass();
            proc.H5Acreate_any_wrap(grandchild_group_id, "starttime", "string", s.dsWhat.get("starttime"), this.verbose);
            this.rb.getClass();
            proc.H5Acreate_any_wrap(grandchild_group_id, "enddate", "string", s.dsWhat.get("enddate"), this.verbose);
            this.rb.getClass();
            proc.H5Acreate_any_wrap(grandchild_group_id, "endtime", "string", s.dsWhat.get("endtime"), this.verbose);
            proc.H5Gclose_wrap(grandchild_group_id, this.verbose);
            grandchild_group_id = proc.H5Gcreate_wrap(child_group_id, "where", 0, this.verbose);
            this.rb.getClass();
            proc.H5Acreate_any_wrap(grandchild_group_id, "elangle", "double", s.dsWhere.get("elangle"), this.verbose);
            this.rb.getClass();
            proc.H5Acreate_any_wrap(grandchild_group_id, "nbins", "long", s.dsWhere.get("nbins"), this.verbose);
            this.rb.getClass();
            proc.H5Acreate_any_wrap(grandchild_group_id, "rstart", "double", s.dsWhere.get("rstart"), this.verbose);
            this.rb.getClass();
            proc.H5Acreate_any_wrap(grandchild_group_id, "rscale", "double", s.dsWhere.get("rscale"), this.verbose);
            this.rb.getClass();
            proc.H5Acreate_any_wrap(grandchild_group_id, "nrays", "long", s.dsWhere.get("nrays"), this.verbose);
            this.rb.getClass();
            proc.H5Acreate_any_wrap(grandchild_group_id, "a1gate", "long", s.dsWhere.get("a1gate"), this.verbose);
            proc.H5Gclose_wrap(grandchild_group_id, this.verbose);
            grandchild_group_id = proc.H5Gcreate_wrap(child_group_id, "data1", 0, this.verbose);
            int grandgrandchild_group_id = -1;
            grandgrandchild_group_id = proc.H5Gcreate_wrap(grandchild_group_id, "what", 0, this.verbose);
            this.rb.getClass();
            proc.H5Acreate_any_wrap(grandgrandchild_group_id, "quantity", "string", s.dsdWhat.get("quantity"), this.verbose);
            this.rb.getClass();
            proc.H5Acreate_any_wrap(grandgrandchild_group_id, "gain", "double", s.dsdWhat.get("gain"), this.verbose);
            this.rb.getClass();
            proc.H5Acreate_any_wrap(grandgrandchild_group_id, "offset", "double", s.dsdWhat.get("offset"), this.verbose);
            this.rb.getClass();
            this.rb.getClass();
            proc.H5Acreate_any_wrap(grandgrandchild_group_id, "nodata", "double", String.valueOf(255.0), this.verbose);
            this.rb.getClass();
            proc.H5Acreate_any_wrap(grandgrandchild_group_id, "undetect", "double", String.valueOf((double)this.rb.PRODUCT), this.verbose);
            proc.H5Gclose_wrap(grandgrandchild_group_id, this.verbose);
            int rays = Integer.parseInt(s.dsWhere.get("nrays"));
            int bins = Integer.parseInt(s.dsWhere.get("nbins"));
            int qiRays = 0;
            int qiBins = 0;
            if (s.dsWhere.get("qi_nrays") != null && !s.dsWhere.get("qi_nrays").isEmpty()) {
                qiRays = Integer.parseInt(s.dsWhere.get("qi_nrays"));
            }
            if (s.dsWhere.get("qi_nbins") != null && !s.dsWhere.get("qi_nbins").isEmpty()) {
                qiBins = Integer.parseInt(s.dsWhere.get("qi_nbins"));
            }
            int dataspace_id = proc.H5Screate_simple_wrap(2, rays, bins, null, this.verbose);
            this.rb.getClass();
            int n = Integer.parseInt("20");
            this.rb.getClass();
            grandgrandchild_group_id = proc.H5Dcreate_wrap(grandchild_group_id, "data", HDF5Constants.H5T_STD_U8BE, dataspace_id, n, Integer.parseInt("6"), this.verbose);
            this.rb.getClass();
            proc.H5Acreate_any_wrap(grandgrandchild_group_id, "CLASS", "string", this.rb.IMAGE, this.verbose);
            this.rb.getClass();
            this.rb.getClass();
            proc.H5Acreate_any_wrap(grandgrandchild_group_id, "IMAGE_VERSION", "string", "1.2", this.verbose);
            int[][] infDataBuff = this.rb.inflate2DRAINBOWDataSection(s.getDataBuff().getDataBuffer(), bins, Integer.parseInt(this.nray_org[i]), this.verbose);
            infDataBuff = proc.shiftAzimuths(infDataBuff, rays, bins, Integer.parseInt(s.dsWhere.get("a1gate")));
            infDataBuff = proc.transposeArray(infDataBuff, rays, bins);
            proc.H5Dwrite_wrap(grandgrandchild_group_id, HDF5Constants.H5T_NATIVE_INT, HDF5Constants.H5S_ALL, HDF5Constants.H5S_ALL, HDF5Constants.H5P_DEFAULT, infDataBuff, this.verbose);
            int[][] infQiBuff = null;
            if (qiRays > 0 && qiBins > 0 && s.getQiBuff() != null) {
                int qi_group_id = -1;
                int qi_children_group_id = -1;
                qi_group_id = proc.H5Gcreate_wrap(grandchild_group_id, "quality1", 0, this.verbose);
                qi_children_group_id = proc.H5Gcreate_wrap(qi_group_id, "what", 0, this.verbose);
                this.rb.getClass();
                proc.H5Acreate_any_wrap(qi_children_group_id, "gain", "double", s.dsdWhat.get("qi_gain"), this.verbose);
                this.rb.getClass();
                proc.H5Acreate_any_wrap(qi_children_group_id, "offset", "double", s.dsdWhat.get("qi_offset"), this.verbose);
                this.rb.getClass();
                this.rb.getClass();
                proc.H5Acreate_any_wrap(qi_children_group_id, "nodata", "double", String.valueOf(255.0), this.verbose);
                this.rb.getClass();
                proc.H5Acreate_any_wrap(qi_children_group_id, "undetect", "double", String.valueOf((double)this.rb.PRODUCT), this.verbose);
                proc.H5Gclose_wrap(qi_children_group_id, this.verbose);
                int qi_dataspace_id = proc.H5Screate_simple_wrap(2, qiRays, qiBins, null, this.verbose);
                this.rb.getClass();
                int n2 = Integer.parseInt("20");
                this.rb.getClass();
                qi_children_group_id = proc.H5Dcreate_wrap(qi_group_id, "data", HDF5Constants.H5T_STD_U8BE, qi_dataspace_id, n2, Integer.parseInt("6"), this.verbose);
                this.rb.getClass();
                proc.H5Acreate_any_wrap(qi_children_group_id, "CLASS", "string", this.rb.IMAGE, this.verbose);
                this.rb.getClass();
                this.rb.getClass();
                proc.H5Acreate_any_wrap(qi_children_group_id, "IMAGE_VERSION", "string", "1.2", this.verbose);
                infQiBuff = this.rb.inflate2DRAINBOWDataSection(s.getQiBuff().getDataBuffer(), qiBins, qiRays, this.verbose);
                infQiBuff = proc.transposeArray(infQiBuff, qiRays, qiBins);
                proc.H5Dwrite_wrap(qi_children_group_id, HDF5Constants.H5T_NATIVE_INT, HDF5Constants.H5S_ALL, HDF5Constants.H5S_ALL, HDF5Constants.H5P_DEFAULT, infQiBuff, this.verbose);
                proc.H5Dclose_wrap(qi_children_group_id, this.verbose);
                proc.H5Gclose_wrap(qi_group_id, this.verbose);
            }
            proc.H5Dclose_wrap(grandgrandchild_group_id, this.verbose);
            proc.H5Gclose_wrap(grandchild_group_id, this.verbose);
            proc.H5Gclose_wrap(child_group_id, this.verbose);
            proc.H5Sclose_wrap(dataspace_id, this.verbose);
            ++i;
        }
        proc.H5Fclose_wrap(file_id, this.verbose);
    }

    private void makeQIfields(HDF5Model proc, int child_group_id) {
        this.rb.getClass();
        proc.H5Acreate_any_wrap(child_group_id, "GEN_a", "double", this.qiG.get("GEN_a"), this.verbose);
        this.rb.getClass();
        proc.H5Acreate_any_wrap(child_group_id, "GEN_b", "double", this.qiG.get("GEN_b"), this.verbose);
        this.rb.getClass();
        proc.H5Acreate_any_wrap(child_group_id, "SYS_QCOn", "long", this.qiG.get("SYS_QCOn"), this.verbose);
        this.rb.getClass();
        proc.H5Acreate_any_wrap(child_group_id, "SYS_QIOn", "long", this.qiG.get("SYS_QIOn"), this.verbose);
        this.rb.getClass();
        proc.H5Acreate_any_wrap(child_group_id, "SYS_Freq", "double", this.qiG.get("SYS_Freq"), this.verbose);
        this.rb.getClass();
        proc.H5Acreate_any_wrap(child_group_id, "SYS_QIFreq", "double", this.qiG.get("SYS_QIFreq"), this.verbose);
        this.rb.getClass();
        proc.H5Acreate_any_wrap(child_group_id, "SYS_Beam", "double", this.qiG.get("SYS_Beam"), this.verbose);
        this.rb.getClass();
        proc.H5Acreate_any_wrap(child_group_id, "SYS_QIBeam", "double", this.qiG.get("SYS_QIBeam"), this.verbose);
        this.rb.getClass();
        proc.H5Acreate_any_wrap(child_group_id, "SYS_Elev", "double", this.qiG.get("SYS_Elev"), this.verbose);
        this.rb.getClass();
        proc.H5Acreate_any_wrap(child_group_id, "SYS_QIElev", "double", this.qiG.get("SYS_QIElev"), this.verbose);
        this.rb.getClass();
        proc.H5Acreate_any_wrap(child_group_id, "SYS_Azim", "double", this.qiG.get("SYS_Azim"), this.verbose);
        this.rb.getClass();
        proc.H5Acreate_any_wrap(child_group_id, "SYS_QIAzim", "double", this.qiG.get("SYS_QIAzim"), this.verbose);
        this.rb.getClass();
        proc.H5Acreate_any_wrap(child_group_id, "SYS_Filter", "double", this.qiG.get("SYS_Filter"), this.verbose);
        this.rb.getClass();
        proc.H5Acreate_any_wrap(child_group_id, "SYS_QIFilter", "double", this.qiG.get("SYS_QIFilter"), this.verbose);
        this.rb.getClass();
        proc.H5Acreate_any_wrap(child_group_id, "SYS_Detect", "double", this.qiG.get("SYS_Detect"), this.verbose);
        this.rb.getClass();
        proc.H5Acreate_any_wrap(child_group_id, "SYS_QIDetect", "double", this.qiG.get("SYS_QIDetect"), this.verbose);
        this.rb.getClass();
        proc.H5Acreate_any_wrap(child_group_id, "SYS_Speed", "double", this.qiG.get("SYS_Speed"), this.verbose);
        this.rb.getClass();
        proc.H5Acreate_any_wrap(child_group_id, "SYS_QISpeed", "double", this.qiG.get("SYS_QISpeed"), this.verbose);
        this.rb.getClass();
        proc.H5Acreate_any_wrap(child_group_id, "SYS_Radome", "double", this.qiG.get("SYS_Radome"), this.verbose);
        this.rb.getClass();
        proc.H5Acreate_any_wrap(child_group_id, "SYS_QIRadome", "double", this.qiG.get("SYS_QIRadome"), this.verbose);
        this.rb.getClass();
        proc.H5Acreate_any_wrap(child_group_id, "SYS_Calibr", "double", this.qiG.get("SYS_Calibr"), this.verbose);
        this.rb.getClass();
        proc.H5Acreate_any_wrap(child_group_id, "SYS_QICalibr", "double", this.qiG.get("SYS_QICalibr"), this.verbose);
        this.rb.getClass();
        proc.H5Acreate_any_wrap(child_group_id, "SYS_TSamp", "double", this.qiG.get("SYS_TSamp"), this.verbose);
        this.rb.getClass();
        proc.H5Acreate_any_wrap(child_group_id, "SYS_QITSamp", "double", this.qiG.get("SYS_QITSamp"), this.verbose);
        this.rb.getClass();
        proc.H5Acreate_any_wrap(child_group_id, "SYS_RSamp", "double", this.qiG.get("SYS_RSamp"), this.verbose);
        this.rb.getClass();
        proc.H5Acreate_any_wrap(child_group_id, "SYS_QIRSamp", "double", this.qiG.get("SYS_QIRSamp"), this.verbose);
        this.rb.getClass();
        proc.H5Acreate_any_wrap(child_group_id, "AH_QCOn", "long", this.qiG.get("AH_QCOn"), this.verbose);
        this.rb.getClass();
        proc.H5Acreate_any_wrap(child_group_id, "AH_QIOn", "long", this.qiG.get("AH_QIOn"), this.verbose);
        this.rb.getClass();
        proc.H5Acreate_any_wrap(child_group_id, "AH_QI0", "double", this.qiG.get("AH_QI0"), this.verbose);
        this.rb.getClass();
        proc.H5Acreate_any_wrap(child_group_id, "AH_QI1", "double", this.qiG.get("AH_QI1"), this.verbose);
        this.rb.getClass();
        proc.H5Acreate_any_wrap(child_group_id, "AV_QCOn", "long", this.qiG.get("AV_QCOn"), this.verbose);
        this.rb.getClass();
        proc.H5Acreate_any_wrap(child_group_id, "AV_QIOn", "long", this.qiG.get("AV_QIOn"), this.verbose);
        this.rb.getClass();
        proc.H5Acreate_any_wrap(child_group_id, "AV_QI0", "double", this.qiG.get("AV_QI0"), this.verbose);
        this.rb.getClass();
        proc.H5Acreate_any_wrap(child_group_id, "AV_QI1", "double", this.qiG.get("AV_QI1"), this.verbose);
        this.rb.getClass();
        proc.H5Acreate_any_wrap(child_group_id, "GC_QCOn", "long", this.qiG.get("GC_QCOn"), this.verbose);
        this.rb.getClass();
        proc.H5Acreate_any_wrap(child_group_id, "GC_QIOn", "long", this.qiG.get("GC_QIOn"), this.verbose);
        this.rb.getClass();
        proc.H5Acreate_any_wrap(child_group_id, "GC_QI", "double", this.qiG.get("GC_QI"), this.verbose);
        this.rb.getClass();
        proc.H5Acreate_any_wrap(child_group_id, "GC_QIUn", "double", this.qiG.get("GC_QIUn"), this.verbose);
        this.rb.getClass();
        proc.H5Acreate_any_wrap(child_group_id, "GC_MinPbb", "double", this.qiG.get("GC_MinPbb"), this.verbose);
        this.rb.getClass();
        proc.H5Acreate_any_wrap(child_group_id, "SPIKE_QCOn", "long", this.qiG.get("SPIKE_QCOn"), this.verbose);
        this.rb.getClass();
        proc.H5Acreate_any_wrap(child_group_id, "SPIKE_QIOn", "long", this.qiG.get("SPIKE_QIOn"), this.verbose);
        this.rb.getClass();
        proc.H5Acreate_any_wrap(child_group_id, "SPIKE_QI", "double", this.qiG.get("SPIKE_QI"), this.verbose);
        this.rb.getClass();
        proc.H5Acreate_any_wrap(child_group_id, "SPIKE_QIUn", "double", this.qiG.get("SPIKE_QIUn"), this.verbose);
        this.rb.getClass();
        proc.H5Acreate_any_wrap(child_group_id, "SPIKE_Diff", "double", this.qiG.get("SPIKE_Diff"), this.verbose);
        this.rb.getClass();
        proc.H5Acreate_any_wrap(child_group_id, "SPIKE_Azim", "double", this.qiG.get("SPIKE_Azim"), this.verbose);
        this.rb.getClass();
        proc.H5Acreate_any_wrap(child_group_id, "SPIKE_Refl", "double", this.qiG.get("SPIKE_Refl"), this.verbose);
        this.rb.getClass();
        proc.H5Acreate_any_wrap(child_group_id, "SPIKE_Perc", "double", this.qiG.get("SPIKE_Perc"), this.verbose);
        this.rb.getClass();
        proc.H5Acreate_any_wrap(child_group_id, "RSPEC_QCOn", "long", this.qiG.get("RSPEC_QCOn"), this.verbose);
        this.rb.getClass();
        proc.H5Acreate_any_wrap(child_group_id, "RSPEC_QIOn", "long", this.qiG.get("RSPEC_QIOn"), this.verbose);
        this.rb.getClass();
        proc.H5Acreate_any_wrap(child_group_id, "RSPEC_QI", "double", this.qiG.get("RSPEC_QI"), this.verbose);
        this.rb.getClass();
        proc.H5Acreate_any_wrap(child_group_id, "RSPEC_QIUn", "double", this.qiG.get("RSPEC_QIUn"), this.verbose);
        this.rb.getClass();
        proc.H5Acreate_any_wrap(child_group_id, "RSPEC_Grid", "double", this.qiG.get("RSPEC_Grid"), this.verbose);
        this.rb.getClass();
        proc.H5Acreate_any_wrap(child_group_id, "RSPEC_Num", "double", this.qiG.get("RSPEC_Num"), this.verbose);
        this.rb.getClass();
        proc.H5Acreate_any_wrap(child_group_id, "RSPEC_Step", "double", this.qiG.get("RSPEC_Step"), this.verbose);
        this.rb.getClass();
        proc.H5Acreate_any_wrap(child_group_id, "SPEC_QCOn", "long", this.qiG.get("SPEC_QCOn"), this.verbose);
        this.rb.getClass();
        proc.H5Acreate_any_wrap(child_group_id, "SPEC_QIOn", "long", this.qiG.get("SPEC_QIOn"), this.verbose);
        this.rb.getClass();
        proc.H5Acreate_any_wrap(child_group_id, "SPEC_QI", "double", this.qiG.get("SPEC_QI"), this.verbose);
        this.rb.getClass();
        proc.H5Acreate_any_wrap(child_group_id, "SPEC_QIUn", "double", this.qiG.get("SPEC_QIUn"), this.verbose);
        this.rb.getClass();
        proc.H5Acreate_any_wrap(child_group_id, "SPEC_Grid", "double", this.qiG.get("SPEC_Grid"), this.verbose);
        this.rb.getClass();
        proc.H5Acreate_any_wrap(child_group_id, "SPEC_Num", "double", this.qiG.get("SPEC_Num"), this.verbose);
        this.rb.getClass();
        proc.H5Acreate_any_wrap(child_group_id, "SPEC_Step", "double", this.qiG.get("SPEC_Step"), this.verbose);
        this.rb.getClass();
        proc.H5Acreate_any_wrap(child_group_id, "PBB_QCOn", "long", this.qiG.get("PBB_QCOn"), this.verbose);
        this.rb.getClass();
        proc.H5Acreate_any_wrap(child_group_id, "PBB_QIOn", "long", this.qiG.get("ATT_QIOn"), this.verbose);
        this.rb.getClass();
        proc.H5Acreate_any_wrap(child_group_id, "PBB_QIUn", "double", this.qiG.get("PBB_QIUn"), this.verbose);
        this.rb.getClass();
        proc.H5Acreate_any_wrap(child_group_id, "PBB_Max", "double", this.qiG.get("PBB_Max"), this.verbose);
        this.rb.getClass();
        proc.H5Acreate_any_wrap(child_group_id, "ATT_QCOn", "long", this.qiG.get("ATT_QCOn"), this.verbose);
        this.rb.getClass();
        proc.H5Acreate_any_wrap(child_group_id, "ATT_QIOn", "long", this.qiG.get("PBB_QIOn"), this.verbose);
        this.rb.getClass();
        proc.H5Acreate_any_wrap(child_group_id, "ATT_a", "double", this.qiG.get("ATT_a"), this.verbose);
        this.rb.getClass();
        proc.H5Acreate_any_wrap(child_group_id, "ATT_b", "double", this.qiG.get("ATT_b"), this.verbose);
        this.rb.getClass();
        proc.H5Acreate_any_wrap(child_group_id, "ATT_QI0", "double", this.qiG.get("ATT_QI0"), this.verbose);
        this.rb.getClass();
        proc.H5Acreate_any_wrap(child_group_id, "ATT_QIUn", "double", this.qiG.get("ATT_QIUn"), this.verbose);
        this.rb.getClass();
        proc.H5Acreate_any_wrap(child_group_id, "ATT_QIUn", "double", this.qiG.get("ATT_QIUn"), this.verbose);
        this.rb.getClass();
        proc.H5Acreate_any_wrap(child_group_id, "ATT_Refl", "double", this.qiG.get("ATT_Refl"), this.verbose);
        this.rb.getClass();
        proc.H5Acreate_any_wrap(child_group_id, "ATT_Last", "double", this.qiG.get("ATT_Last"), this.verbose);
        this.rb.getClass();
        proc.H5Acreate_any_wrap(child_group_id, "ATT_Sum", "double", this.qiG.get("ATT_Sum"), this.verbose);
        this.rb.getClass();
        proc.H5Acreate_any_wrap(child_group_id, "SUM_QCOn", "long", this.qiG.get("SUM_QCOn"), this.verbose);
        this.rb.getClass();
        proc.H5Acreate_any_wrap(child_group_id, "SUM_QIOn", "long", this.qiG.get("SUM_QIOn"), this.verbose);
        this.rb.getClass();
        proc.H5Acreate_any_wrap(child_group_id, "SUM_QI0", "double", this.qiG.get("SUM_QI0"), this.verbose);
        this.rb.getClass();
        proc.H5Acreate_any_wrap(child_group_id, "SUM_QI1", "double", this.qiG.get("SUM_QI1"), this.verbose);
    }

    private HashMap<String, String> makeWhatGroup(Document inputDoc) {
        NodeList nodeList = null;
        HashMap<String, String> what = new HashMap<String, String>();
        String source = "";
        if (this.version.substring(0, 3).matches(VER51X) || this.version.substring(0, 3).matches(VER52X)) {
            nodeList = this.rb.getRAINBOWNodesByName(inputDoc, "radarinfo", this.verbose);
            source = this.rb.getRAINBOWMetadataElement(nodeList, "id", this.verbose);
            this.radarFullName = this.rb.getRAINBOWMetadataElement(nodeList, "name", this.verbose);
        } else if (this.version.substring(0, 3).matches(VER53X)) {
            nodeList = this.rb.getRAINBOWNodesByName(inputDoc, "sensorinfo", this.verbose);
            source = this.rb.getRAINBOWMetadataElement(nodeList, "id", this.verbose);
            this.radarFullName = this.rb.getRAINBOWMetadataElement(nodeList, "name", this.verbose);
        } else {
            System.out.println("version of the volume not supported");
            return null;
        }
        this.source = source;
        String radarName = "";
        int i = 0;
        while (i < this.options.length) {
            if (source.matches(this.options[i].getRadarName())) {
                radarName = this.options[i].getRadarWMOName();
                this.filePrefix = this.options[i].getFileName();
                if (this.options[i].getNrays() != null) {
                    this.nray_new = this.options[i].getNrays();
                }
                if (this.options[i].getLocation() == null) break;
                this.radarFullName = this.options[i].getLocation();
                break;
            }
            ++i;
        }
        if (radarName.isEmpty()) {
            System.out.println("Add " + source + " to options.xml");
            return null;
        }
        source = "WMO:" + radarName;
        nodeList = this.rb.getRAINBOWNodesByName(inputDoc, "scan", this.verbose);
        this.date = this.rb.getRAINBOWMetadataElement(nodeList, "date", this.verbose);
        nodeList = this.rb.getRAINBOWNodesByName(inputDoc, "scan", this.verbose);
        this.time = this.rb.getRAINBOWMetadataElement(nodeList, "time", this.verbose);
        what.put("date", this.rb.parseRAINBOWDate(this.date, this.verbose));
        what.put("source", source);
        what.put("time", this.rb.parseRAINBOWTime(this.time, this.verbose));
        return what;
    }

    private HashMap<String, String> makeHowGroup(Document inputDoc) {
        HashMap<String, String> how = new HashMap<String, String>();
        NodeList nodeList = null;
        nodeList = this.rb.getRAINBOWNodesByName(inputDoc, "beamwidth", this.verbose);
        String beamwidth = this.rb.getRAINBOWMetadataElement(nodeList, "", this.verbose);
        nodeList = this.rb.getRAINBOWNodesByName(inputDoc, "wavelen", this.verbose);
        String wavelength = this.rb.getRAINBOWMetadataElement(nodeList, "", this.verbose);
        how.put("startepochs", this.rb.convertRAINBOWDate2Epoch(this.date, this.time, this.verbose));
        how.put("endepochs", this.rb.convertRAINBOWDate2Epoch(this.date, this.time, this.verbose));
        this.rb.getClass();
        how.put("system", "GEMA");
        this.rb.getClass();
        how.put("software", "RAINBOW");
        how.put("sw_version", this.version);
        how.put("beamwidth", beamwidth);
        how.put("wavelength", wavelength);
        return how;
    }

    private HashMap<String, String> makeQIGroup(Document inputDoc) {
        HashMap<String, String> qi = new HashMap<String, String>();
        NodeList nodeList = null;
        String value = "";
        nodeList = this.rb.getRAINBOWNodesByName(inputDoc, "GEN_a", this.verbose);
        value = this.rb.getRAINBOWMetadataElement(nodeList, "", this.verbose);
        qi.put("GEN_a", value);
        nodeList = this.rb.getRAINBOWNodesByName(inputDoc, "GEN_b", this.verbose);
        value = this.rb.getRAINBOWMetadataElement(nodeList, "", this.verbose);
        qi.put("GEN_b", value);
        nodeList = this.rb.getRAINBOWNodesByName(inputDoc, "SYS_QCOn", this.verbose);
        value = this.rb.getRAINBOWMetadataElement(nodeList, "", this.verbose);
        qi.put("SYS_QCOn", value);
        nodeList = this.rb.getRAINBOWNodesByName(inputDoc, "SYS_QIOn", this.verbose);
        value = this.rb.getRAINBOWMetadataElement(nodeList, "", this.verbose);
        qi.put("SYS_QIOn", value);
        nodeList = this.rb.getRAINBOWNodesByName(inputDoc, "SYS_Freq", this.verbose);
        value = this.rb.getRAINBOWMetadataElement(nodeList, "", this.verbose);
        qi.put("SYS_Freq", value);
        nodeList = this.rb.getRAINBOWNodesByName(inputDoc, "SYS_QIFreq", this.verbose);
        value = this.rb.getRAINBOWMetadataElement(nodeList, "", this.verbose);
        qi.put("SYS_QIFreq", value);
        nodeList = this.rb.getRAINBOWNodesByName(inputDoc, "SYS_Beam", this.verbose);
        value = this.rb.getRAINBOWMetadataElement(nodeList, "", this.verbose);
        qi.put("SYS_Beam", value);
        nodeList = this.rb.getRAINBOWNodesByName(inputDoc, "SYS_QIBeam", this.verbose);
        value = this.rb.getRAINBOWMetadataElement(nodeList, "", this.verbose);
        qi.put("SYS_QIBeam", value);
        nodeList = this.rb.getRAINBOWNodesByName(inputDoc, "SYS_Elev", this.verbose);
        value = this.rb.getRAINBOWMetadataElement(nodeList, "", this.verbose);
        qi.put("SYS_Elev", value);
        nodeList = this.rb.getRAINBOWNodesByName(inputDoc, "SYS_QIElev", this.verbose);
        value = this.rb.getRAINBOWMetadataElement(nodeList, "", this.verbose);
        qi.put("SYS_QIElev", value);
        nodeList = this.rb.getRAINBOWNodesByName(inputDoc, "SYS_Azim", this.verbose);
        value = this.rb.getRAINBOWMetadataElement(nodeList, "", this.verbose);
        qi.put("SYS_Azim", value);
        nodeList = this.rb.getRAINBOWNodesByName(inputDoc, "SYS_QIAzim", this.verbose);
        value = this.rb.getRAINBOWMetadataElement(nodeList, "", this.verbose);
        qi.put("SYS_QIAzim", value);
        nodeList = this.rb.getRAINBOWNodesByName(inputDoc, "SYS_Filter", this.verbose);
        value = this.rb.getRAINBOWMetadataElement(nodeList, "", this.verbose);
        qi.put("SYS_Filter", value);
        nodeList = this.rb.getRAINBOWNodesByName(inputDoc, "SYS_QIFilter", this.verbose);
        value = this.rb.getRAINBOWMetadataElement(nodeList, "", this.verbose);
        qi.put("SYS_QIFilter", value);
        nodeList = this.rb.getRAINBOWNodesByName(inputDoc, "SYS_Detect", this.verbose);
        value = this.rb.getRAINBOWMetadataElement(nodeList, "", this.verbose);
        qi.put("SYS_Detect", value);
        nodeList = this.rb.getRAINBOWNodesByName(inputDoc, "SYS_QIDetect", this.verbose);
        value = this.rb.getRAINBOWMetadataElement(nodeList, "", this.verbose);
        qi.put("SYS_QIDetect", value);
        nodeList = this.rb.getRAINBOWNodesByName(inputDoc, "SYS_Speed", this.verbose);
        value = this.rb.getRAINBOWMetadataElement(nodeList, "", this.verbose);
        qi.put("SYS_Speed", value);
        nodeList = this.rb.getRAINBOWNodesByName(inputDoc, "SYS_QISpeed", this.verbose);
        value = this.rb.getRAINBOWMetadataElement(nodeList, "", this.verbose);
        qi.put("SYS_QISpeed", value);
        nodeList = this.rb.getRAINBOWNodesByName(inputDoc, "SYS_Radome", this.verbose);
        value = this.rb.getRAINBOWMetadataElement(nodeList, "", this.verbose);
        qi.put("SYS_Radome", value);
        nodeList = this.rb.getRAINBOWNodesByName(inputDoc, "SYS_QIRadome", this.verbose);
        value = this.rb.getRAINBOWMetadataElement(nodeList, "", this.verbose);
        qi.put("SYS_QIRadome", value);
        nodeList = this.rb.getRAINBOWNodesByName(inputDoc, "SYS_Calibr", this.verbose);
        value = this.rb.getRAINBOWMetadataElement(nodeList, "", this.verbose);
        qi.put("SYS_Calibr", value);
        nodeList = this.rb.getRAINBOWNodesByName(inputDoc, "SYS_QICalibr", this.verbose);
        value = this.rb.getRAINBOWMetadataElement(nodeList, "", this.verbose);
        qi.put("SYS_QICalibr", value);
        nodeList = this.rb.getRAINBOWNodesByName(inputDoc, "SYS_TSamp", this.verbose);
        value = this.rb.getRAINBOWMetadataElement(nodeList, "", this.verbose);
        qi.put("SYS_TSamp", value);
        nodeList = this.rb.getRAINBOWNodesByName(inputDoc, "SYS_QITSamp", this.verbose);
        value = this.rb.getRAINBOWMetadataElement(nodeList, "", this.verbose);
        qi.put("SYS_QITSamp", value);
        nodeList = this.rb.getRAINBOWNodesByName(inputDoc, "SYS_RSamp", this.verbose);
        value = this.rb.getRAINBOWMetadataElement(nodeList, "", this.verbose);
        qi.put("SYS_RSamp", value);
        nodeList = this.rb.getRAINBOWNodesByName(inputDoc, "SYS_QIRSamp", this.verbose);
        value = this.rb.getRAINBOWMetadataElement(nodeList, "", this.verbose);
        qi.put("SYS_QIRSamp", value);
        nodeList = this.rb.getRAINBOWNodesByName(inputDoc, "AH_QCOn", this.verbose);
        value = this.rb.getRAINBOWMetadataElement(nodeList, "", this.verbose);
        qi.put("AH_QCOn", value);
        nodeList = this.rb.getRAINBOWNodesByName(inputDoc, "AH_QIOn", this.verbose);
        value = this.rb.getRAINBOWMetadataElement(nodeList, "", this.verbose);
        qi.put("AH_QIOn", value);
        nodeList = this.rb.getRAINBOWNodesByName(inputDoc, "AH_QI0", this.verbose);
        value = this.rb.getRAINBOWMetadataElement(nodeList, "", this.verbose);
        qi.put("AH_QI0", value);
        nodeList = this.rb.getRAINBOWNodesByName(inputDoc, "AH_QI1", this.verbose);
        value = this.rb.getRAINBOWMetadataElement(nodeList, "", this.verbose);
        qi.put("AH_QI1", value);
        nodeList = this.rb.getRAINBOWNodesByName(inputDoc, "AV_QCOn", this.verbose);
        value = this.rb.getRAINBOWMetadataElement(nodeList, "", this.verbose);
        qi.put("AV_QCOn", value);
        nodeList = this.rb.getRAINBOWNodesByName(inputDoc, "AV_QIOn", this.verbose);
        value = this.rb.getRAINBOWMetadataElement(nodeList, "", this.verbose);
        qi.put("AV_QIOn", value);
        nodeList = this.rb.getRAINBOWNodesByName(inputDoc, "AV_QI0", this.verbose);
        value = this.rb.getRAINBOWMetadataElement(nodeList, "", this.verbose);
        qi.put("AV_QI0", value);
        nodeList = this.rb.getRAINBOWNodesByName(inputDoc, "AV_QI1", this.verbose);
        value = this.rb.getRAINBOWMetadataElement(nodeList, "", this.verbose);
        qi.put("AV_QI1", value);
        nodeList = this.rb.getRAINBOWNodesByName(inputDoc, "GC_QCOn", this.verbose);
        value = this.rb.getRAINBOWMetadataElement(nodeList, "", this.verbose);
        qi.put("AH_QCOn", value);
        nodeList = this.rb.getRAINBOWNodesByName(inputDoc, "GC_QIOn", this.verbose);
        value = this.rb.getRAINBOWMetadataElement(nodeList, "", this.verbose);
        qi.put("GC_QIOn", value);
        nodeList = this.rb.getRAINBOWNodesByName(inputDoc, "GC_QI", this.verbose);
        value = this.rb.getRAINBOWMetadataElement(nodeList, "", this.verbose);
        qi.put("GC_QI", value);
        nodeList = this.rb.getRAINBOWNodesByName(inputDoc, "GC_QIUn", this.verbose);
        value = this.rb.getRAINBOWMetadataElement(nodeList, "", this.verbose);
        qi.put("GC_QIUn", value);
        nodeList = this.rb.getRAINBOWNodesByName(inputDoc, "GC_MinPbb", this.verbose);
        value = this.rb.getRAINBOWMetadataElement(nodeList, "", this.verbose);
        qi.put("GC_MinPbb", value);
        nodeList = this.rb.getRAINBOWNodesByName(inputDoc, "SPIKE_QCOn", this.verbose);
        value = this.rb.getRAINBOWMetadataElement(nodeList, "", this.verbose);
        qi.put("SPIKE_QCOn", value);
        nodeList = this.rb.getRAINBOWNodesByName(inputDoc, "SPIKE_QIOn", this.verbose);
        value = this.rb.getRAINBOWMetadataElement(nodeList, "", this.verbose);
        qi.put("SPIKE_QIOn", value);
        nodeList = this.rb.getRAINBOWNodesByName(inputDoc, "SPIKE_QI", this.verbose);
        value = this.rb.getRAINBOWMetadataElement(nodeList, "", this.verbose);
        qi.put("SPIKE_QI", value);
        nodeList = this.rb.getRAINBOWNodesByName(inputDoc, "SPIKE_QIUn", this.verbose);
        value = this.rb.getRAINBOWMetadataElement(nodeList, "", this.verbose);
        qi.put("SPIKE_QIUn", value);
        nodeList = this.rb.getRAINBOWNodesByName(inputDoc, "SPIKE_Diff", this.verbose);
        value = this.rb.getRAINBOWMetadataElement(nodeList, "", this.verbose);
        qi.put("SPIKE_Diff", value);
        nodeList = this.rb.getRAINBOWNodesByName(inputDoc, "SPIKE_Azim", this.verbose);
        value = this.rb.getRAINBOWMetadataElement(nodeList, "", this.verbose);
        qi.put("SPIKE_Azim", value);
        nodeList = this.rb.getRAINBOWNodesByName(inputDoc, "SPIKE_Refl", this.verbose);
        value = this.rb.getRAINBOWMetadataElement(nodeList, "", this.verbose);
        qi.put("SPIKE_Refl", value);
        nodeList = this.rb.getRAINBOWNodesByName(inputDoc, "SPIKE_Perc", this.verbose);
        value = this.rb.getRAINBOWMetadataElement(nodeList, "", this.verbose);
        qi.put("SPIKE_Perc", value);
        nodeList = this.rb.getRAINBOWNodesByName(inputDoc, "RSPEC_QCOn", this.verbose);
        value = this.rb.getRAINBOWMetadataElement(nodeList, "", this.verbose);
        qi.put("RSPEC_QCOn", value);
        nodeList = this.rb.getRAINBOWNodesByName(inputDoc, "RSPEC_QIOn", this.verbose);
        value = this.rb.getRAINBOWMetadataElement(nodeList, "", this.verbose);
        qi.put("RSPEC_QIOn", value);
        nodeList = this.rb.getRAINBOWNodesByName(inputDoc, "RSPEC_QI", this.verbose);
        value = this.rb.getRAINBOWMetadataElement(nodeList, "", this.verbose);
        qi.put("RSPEC_QI", value);
        nodeList = this.rb.getRAINBOWNodesByName(inputDoc, "RSPEC_QIUn", this.verbose);
        value = this.rb.getRAINBOWMetadataElement(nodeList, "", this.verbose);
        qi.put("RSPEC_QIUn", value);
        nodeList = this.rb.getRAINBOWNodesByName(inputDoc, "RSPEC_Grid", this.verbose);
        value = this.rb.getRAINBOWMetadataElement(nodeList, "", this.verbose);
        qi.put("RSPEC_Grid", value);
        nodeList = this.rb.getRAINBOWNodesByName(inputDoc, "RSPEC_Num", this.verbose);
        value = this.rb.getRAINBOWMetadataElement(nodeList, "", this.verbose);
        qi.put("RSPEC_Num", value);
        nodeList = this.rb.getRAINBOWNodesByName(inputDoc, "RSPEC_Step", this.verbose);
        value = this.rb.getRAINBOWMetadataElement(nodeList, "", this.verbose);
        qi.put("RSPEC_Step", value);
        nodeList = this.rb.getRAINBOWNodesByName(inputDoc, "SPEC_QCOn", this.verbose);
        value = this.rb.getRAINBOWMetadataElement(nodeList, "", this.verbose);
        qi.put("SPEC_QCOn", value);
        nodeList = this.rb.getRAINBOWNodesByName(inputDoc, "SPEC_QIOn", this.verbose);
        value = this.rb.getRAINBOWMetadataElement(nodeList, "", this.verbose);
        qi.put("SPEC_QIOn", value);
        nodeList = this.rb.getRAINBOWNodesByName(inputDoc, "SPEC_QI", this.verbose);
        value = this.rb.getRAINBOWMetadataElement(nodeList, "", this.verbose);
        qi.put("SPEC_QI", value);
        nodeList = this.rb.getRAINBOWNodesByName(inputDoc, "SPEC_QIUn", this.verbose);
        value = this.rb.getRAINBOWMetadataElement(nodeList, "", this.verbose);
        qi.put("SPEC_QIUn", value);
        nodeList = this.rb.getRAINBOWNodesByName(inputDoc, "SPEC_Grid", this.verbose);
        value = this.rb.getRAINBOWMetadataElement(nodeList, "", this.verbose);
        qi.put("SPEC_Grid", value);
        nodeList = this.rb.getRAINBOWNodesByName(inputDoc, "SPEC_Num", this.verbose);
        value = this.rb.getRAINBOWMetadataElement(nodeList, "", this.verbose);
        qi.put("SPEC_Num", value);
        nodeList = this.rb.getRAINBOWNodesByName(inputDoc, "SPEC_Step", this.verbose);
        value = this.rb.getRAINBOWMetadataElement(nodeList, "", this.verbose);
        qi.put("SPEC_Step", value);
        nodeList = this.rb.getRAINBOWNodesByName(inputDoc, "PBB_QCOn", this.verbose);
        value = this.rb.getRAINBOWMetadataElement(nodeList, "", this.verbose);
        qi.put("PBB_QCOn", value);
        nodeList = this.rb.getRAINBOWNodesByName(inputDoc, "PBB_QIOn", this.verbose);
        value = this.rb.getRAINBOWMetadataElement(nodeList, "", this.verbose);
        qi.put("PBB_QIOn", value);
        nodeList = this.rb.getRAINBOWNodesByName(inputDoc, "PBB_Max", this.verbose);
        value = this.rb.getRAINBOWMetadataElement(nodeList, "", this.verbose);
        qi.put("PBB_Max", value);
        nodeList = this.rb.getRAINBOWNodesByName(inputDoc, "PBB_QIUn", this.verbose);
        value = this.rb.getRAINBOWMetadataElement(nodeList, "", this.verbose);
        qi.put("PBB_QIUn", value);
        nodeList = this.rb.getRAINBOWNodesByName(inputDoc, "ATT_QCOn", this.verbose);
        value = this.rb.getRAINBOWMetadataElement(nodeList, "", this.verbose);
        qi.put("ATT_QCOn", value);
        nodeList = this.rb.getRAINBOWNodesByName(inputDoc, "ATT_QIOn", this.verbose);
        value = this.rb.getRAINBOWMetadataElement(nodeList, "", this.verbose);
        qi.put("ATT_QIOn", value);
        nodeList = this.rb.getRAINBOWNodesByName(inputDoc, "ATT_a", this.verbose);
        value = this.rb.getRAINBOWMetadataElement(nodeList, "", this.verbose);
        qi.put("ATT_a", value);
        nodeList = this.rb.getRAINBOWNodesByName(inputDoc, "ATT_b", this.verbose);
        value = this.rb.getRAINBOWMetadataElement(nodeList, "", this.verbose);
        qi.put("ATT_b", value);
        nodeList = this.rb.getRAINBOWNodesByName(inputDoc, "ATT_QIUn", this.verbose);
        value = this.rb.getRAINBOWMetadataElement(nodeList, "", this.verbose);
        qi.put("ATT_QIUn", value);
        nodeList = this.rb.getRAINBOWNodesByName(inputDoc, "ATT_QIUn", this.verbose);
        value = this.rb.getRAINBOWMetadataElement(nodeList, "", this.verbose);
        qi.put("ATT_QIUn", value);
        nodeList = this.rb.getRAINBOWNodesByName(inputDoc, "ATT_QI0", this.verbose);
        value = this.rb.getRAINBOWMetadataElement(nodeList, "", this.verbose);
        qi.put("ATT_QI0", value);
        nodeList = this.rb.getRAINBOWNodesByName(inputDoc, "ATT_Refl", this.verbose);
        value = this.rb.getRAINBOWMetadataElement(nodeList, "", this.verbose);
        qi.put("ATT_Refl", value);
        nodeList = this.rb.getRAINBOWNodesByName(inputDoc, "ATT_Last", this.verbose);
        value = this.rb.getRAINBOWMetadataElement(nodeList, "", this.verbose);
        qi.put("ATT_Last", value);
        nodeList = this.rb.getRAINBOWNodesByName(inputDoc, "ATT_Sum", this.verbose);
        value = this.rb.getRAINBOWMetadataElement(nodeList, "", this.verbose);
        qi.put("ATT_Sum", value);
        nodeList = this.rb.getRAINBOWNodesByName(inputDoc, "SUM_QCOn", this.verbose);
        value = this.rb.getRAINBOWMetadataElement(nodeList, "", this.verbose);
        qi.put("SUM_QCOn", value);
        nodeList = this.rb.getRAINBOWNodesByName(inputDoc, "SUM_QIOn", this.verbose);
        value = this.rb.getRAINBOWMetadataElement(nodeList, "", this.verbose);
        qi.put("SUM_QIOn", value);
        nodeList = this.rb.getRAINBOWNodesByName(inputDoc, "SUM_QI0", this.verbose);
        value = this.rb.getRAINBOWMetadataElement(nodeList, "", this.verbose);
        qi.put("SUM_QI0", value);
        nodeList = this.rb.getRAINBOWNodesByName(inputDoc, "SUM_QI1", this.verbose);
        value = this.rb.getRAINBOWMetadataElement(nodeList, "", this.verbose);
        qi.put("SUM_QI1", value);
        return qi;
    }

    private String getZeroOneValue(String value) {
        if (value.matches("On")) {
            return "1";
        }
        return "0";
    }

    private HashMap<String, String> makeWhereGroup(Document inputDoc) {
        HashMap<String, String> where = new HashMap<String, String>();
        NodeList nodeList = null;
        String lon = "";
        String lat = "";
        String height = "";
        if (this.version.substring(0, 3).matches(VER51X) || this.version.substring(0, 3).matches(VER52X)) {
            nodeList = this.rb.getRAINBOWNodesByName(inputDoc, "radarinfo", this.verbose);
            lon = this.rb.getRAINBOWMetadataElement(nodeList, "lon", this.verbose);
            nodeList = this.rb.getRAINBOWNodesByName(inputDoc, "radarinfo", this.verbose);
            lat = this.rb.getRAINBOWMetadataElement(nodeList, "lat", this.verbose);
            nodeList = this.rb.getRAINBOWNodesByName(inputDoc, "radarinfo", this.verbose);
            height = this.rb.getRAINBOWMetadataElement(nodeList, "alt", this.verbose);
        } else if (this.version.substring(0, 3).matches(VER53X)) {
            nodeList = this.rb.getRAINBOWNodesByName(inputDoc, "lon", this.verbose);
            lon = this.rb.getRAINBOWMetadataElement(nodeList, "", this.verbose);
            nodeList = this.rb.getRAINBOWNodesByName(inputDoc, "lat", this.verbose);
            lat = this.rb.getRAINBOWMetadataElement(nodeList, "", this.verbose);
            nodeList = this.rb.getRAINBOWNodesByName(inputDoc, "alt", this.verbose);
            height = this.rb.getRAINBOWMetadataElement(nodeList, "", this.verbose);
        } else {
            return null;
        }
        where.put("lon", lon);
        where.put("lat", lat);
        where.put("height", height);
        return where;
    }

    private PVOLSlicesCont[] makeSlices(NodeList sliceList) {
        PVOLSlicesCont[] slices = new PVOLSlicesCont[this.size];
        this.nray_org = new String[this.size];
        int i = 0;
        while (i < this.size) {
            slices[i] = new PVOLSlicesCont();
            int raysBlobNumber = Integer.parseInt(RainbowModel.getValueByName(sliceList.item(i), "rayinfo", "blobid"));
            int dataBlobNumber = Integer.parseInt(RainbowModel.getValueByName(sliceList.item(i), "rawdata", "blobid"));
            String qi = RainbowModel.getValueByName(sliceList.item(i), "QIdata", "blobid");
            int qiBlobNumber = -1;
            if (qi != null && !qi.isEmpty()) {
                qiBlobNumber = Integer.parseInt(qi);
            }
            String date = this.rb.parseRAINBOWDate(RainbowModel.getValueByName(sliceList.item(i), "slicedata", "date"), this.verbose);
            String time = this.rb.parseRAINBOWTime(RainbowModel.getValueByName(sliceList.item(i), "slicedata", "time"), this.verbose);
            slices[i].dsWhat.put("product", PRODUCT);
            slices[i].dsWhat.put("startdate", date);
            slices[i].dsWhat.put("starttime", time);
            slices[i].dsWhat.put("enddate", date);
            slices[i].dsWhat.put("endtime", this.rb.parseRAINBOWTime(time, this.shift, this.verbose));
            String posangle = RainbowModel.getValueByName(sliceList.item(i), "posangle", null);
            String bins = RainbowModel.getValueByName(sliceList.item(i), "rawdata", "bins");
            String srange = RainbowModel.getValueByName(sliceList.item(i), "start_range", null);
            String qiBins = RainbowModel.getValueByName(sliceList.item(i), "QIdata", "bins");
            String qiRays = RainbowModel.getValueByName(sliceList.item(i), "QIdata", "rays");
            String dataDepth = RainbowModel.getValueByName(sliceList.item(i), "QIdata", "depth");
            String min = RainbowModel.getValueByName(sliceList.item(i), "QIdata", "min");
            String max = RainbowModel.getValueByName(sliceList.item(i), "QIdata", "max");
            String gain = null;
            if (min != null && max != null) {
                gain = this.rb.getRAINBOWGain(min, max, Integer.parseInt(dataDepth));
                slices[i].dsdWhat.put("qi_gain", gain);
                slices[i].dsdWhat.put("qi_offset", this.rb.getRAINBOWOffset(min, gain));
            }
            if (srange == null) {
                srange = "0";
            }
            this.nray_org[i] = RainbowModel.getValueByName(sliceList.item(i), "rawdata", "rays");
            DataBufferContainer raysBuff = this.blobs.get(raysBlobNumber);
            byte[] infRaysBuff = this.rb.inflate1DRAINBOWDataSection(raysBuff.getDataBuffer(), raysBuff.getDataBufferLength(), this.verbose);
            String a1gate = String.valueOf(this.startingAzimuthNumber(infRaysBuff, Integer.parseInt(this.nray_org[i])));
            String rays = "";
            rays = !this.nray_new.isEmpty() ? this.nray_new : this.nray_org[i];
            slices[i].dsWhere.put("elangle", posangle);
            slices[i].dsWhere.put("nbins", bins);
            slices[i].dsWhere.put("rstart", srange);
            slices[i].dsWhere.put("rscale", this.rangestep);
            slices[i].dsWhere.put("nrays", rays);
            slices[i].dsWhere.put("a1gate", a1gate);
            if (qiBlobNumber > -1) {
                slices[i].dsWhere.put("qi_nbins", qiBins);
                slices[i].dsWhere.put("qi_nrays", qiRays);
            }
            String dataType = RainbowModel.getValueByName(sliceList.item(i), "rawdata", "type");
            this.rb.getClass();
            if (dataType.matches("dBZ")) {
                dataType = "DBZH";
            } else {
                this.rb.getClass();
                if (dataType.matches("uPhiDP")) {
                    dataType = "PHIDP";
                }
            }
            dataDepth = RainbowModel.getValueByName(sliceList.item(i), "rawdata", "depth");
            min = RainbowModel.getValueByName(sliceList.item(i), "rawdata", "min");
            max = RainbowModel.getValueByName(sliceList.item(i), "rawdata", "max");
            gain = this.rb.getRAINBOWGain(min, max, Integer.parseInt(dataDepth));
            slices[i].dsdWhat.put("quantity", dataType);
            slices[i].dsdWhat.put("gain", gain);
            slices[i].dsdWhat.put("offset", this.rb.getRAINBOWOffset(min, gain));
            DataBufferContainer dataBuff = this.blobs.get(dataBlobNumber);
            DataBufferContainer qiBuff = null;
            if (qiBlobNumber > -1) {
                qiBuff = this.blobs.get(qiBlobNumber);
            }
            slices[i].dsdData.put("data_size", dataDepth);
            slices[i].setDataBuff(dataBuff);
            if (qiBuff != null) {
                slices[i].setQiBuff(qiBuff);
            }
            ++i;
        }
        return slices;
    }

    public int startingAzimuthNumber(byte[] data, int length) {
        int value = 0;
        int minValue = 99999;
        int counter = 0;
        int i = 0;
        while (i < length) {
            value = this.byte2int(data[i * 2], data[i * 2 + 1]);
            if (value < minValue) {
                minValue = value;
                counter = i;
            }
            ++i;
        }
        return counter;
    }

    public int byte2int(byte high, byte low) {
        return (high & 0xFF) << 8 | low & 0xFF;
    }

    public String getOutputFileName() {
        return this.outputFileName;
    }

    public String getRadarName() {
        return this.source;
    }

    public String getRadarFullName() {
        return this.radarFullName;
    }
}

