/*
 * Decompiled with CFR 0.152.
 */
package pl.imgw.odimH5.model.rainbow;

import java.io.File;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import pl.imgw.odimH5.model.ParametersContainer;
import pl.imgw.odimH5.model.rainbow.RainbowModel;
import pl.imgw.odimH5.util.RadarOptions;

public class ModelVP {
    public static String createDescriptor(String fileName, byte[] fileBuff, boolean verbose, RainbowModel rb, RadarOptions[] options) {
        byte[] hdrBuff = rb.getRAINBOWMetadata(fileBuff, rb.PRODUCT, verbose);
        Document inputDoc = rb.parseRAINBOWMetadataBuffer(hdrBuff, verbose);
        NodeList nodeList = null;
        ParametersContainer cont = new ParametersContainer();
        nodeList = rb.getRAINBOWNodesByName(inputDoc, "data", verbose);
        String date = rb.getRAINBOWMetadataElement(nodeList, "date", verbose);
        nodeList = rb.getRAINBOWNodesByName(inputDoc, "data", verbose);
        String time = rb.getRAINBOWMetadataElement(nodeList, "time", verbose);
        nodeList = rb.getRAINBOWNodesByName(inputDoc, "name", verbose);
        cont.setDate(rb.parseRAINBOWDate(date, verbose));
        cont.setTime(rb.parseRAINBOWTime(time, verbose));
        nodeList = rb.getRAINBOWNodesByName(inputDoc, "radarinfo", verbose);
        String source = rb.getRAINBOWMetadataElement(nodeList, "id", verbose);
        String radarName = "";
        int i = 0;
        while (i < options.length) {
            if (source.matches(options[i].getRadarName())) {
                radarName = options[i].getRadarWMOName();
                break;
            }
            ++i;
        }
        if (radarName.isEmpty()) {
            System.out.println("Add " + source + " to options.xml");
            System.exit(0);
        } else {
            source = "WMO:" + radarName;
        }
        cont.setSource(source);
        String dataDir = rb.hdf.createDirectory("data", verbose);
        StringBuilder stringBuilder = new StringBuilder(String.valueOf(dataDir)).append(File.separator);
        rb.getClass();
        String dataFileName = stringBuilder.append("data1").append(".dat").toString();
        cont.setDataFileName(dataFileName);
        Document od = rb.hdf.createXMLDocumentObject(verbose);
        Comment comment = od.createComment("ODIM_H5 descriptor file, platform: RAINBOW, file object: " + rb.VP);
        od.appendChild(comment);
        rb.getClass();
        Element root = od.createElement("group");
        rb.getClass();
        rb.getClass();
        root.setAttribute("name", "/");
        od.appendChild(root);
        rb.hdf.saveXMLFile(od, fileName, verbose);
        return fileName;
    }
}

