/*
 * Decompiled with CFR 0.152.
 */
package pl.imgw.odimH5.model.rainbow;

import java.io.File;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import pl.imgw.odimH5.model.ParametersContainer;
import pl.imgw.odimH5.model.rainbow.ModelImageH5;
import pl.imgw.odimH5.model.rainbow.ModelImageXML;
import pl.imgw.odimH5.model.rainbow.RainbowModel;
import pl.imgw.odimH5.util.DataBufferContainer;
import pl.imgw.odimH5.util.RadarOptions;

public class ModelImage {
    public static String createDescriptor(String fileNameOut, byte[] fileBuff, boolean verbose, RainbowModel rb, RadarOptions[] options) {
        boolean isDirect = false;
        if (fileNameOut.endsWith(".h5") || fileNameOut.isEmpty()) {
            isDirect = true;
        }
        byte[] hdrBuff = rb.getRAINBOWMetadata(fileBuff, rb.PRODUCT, verbose);
        Document inputDoc = rb.parseRAINBOWMetadataBuffer(hdrBuff, verbose);
        NodeList nodeList = null;
        ParametersContainer cont = new ParametersContainer();
        nodeList = rb.getRAINBOWNodesByName(inputDoc, "data", verbose);
        String date = rb.getRAINBOWMetadataElement(nodeList, "date", verbose);
        String time = rb.getRAINBOWMetadataElement(nodeList, "time", verbose);
        nodeList = rb.getRAINBOWNodesByName(inputDoc, "radarinfo", verbose);
        String source = rb.getRAINBOWMetadataElement(nodeList, "id", verbose);
        String radarName = "";
        int i = 0;
        while (i < options.length) {
            if (source.matches(options[i].getRadarName())) {
                radarName = options[i].getRadarWMOName();
                break;
            }
            ++i;
        }
        if (radarName.isEmpty()) {
            System.out.println("Add " + source + " to options.xml");
            System.exit(0);
        } else {
            source = "WMO:" + radarName;
        }
        cont.setSource(source);
        NodeList pictureList = inputDoc.getElementsByTagName("radarpicture");
        int datasetSize = pictureList.getLength();
        Node radarPicture = null;
        int i2 = 0;
        while (i2 < datasetSize) {
            String placeid = pictureList.item(i2).getAttributes().getNamedItem("placeid").getNodeValue();
            if (placeid.matches("top") || placeid.matches("etop")) {
                radarPicture = pictureList.item(i2);
                break;
            }
            ++i2;
        }
        cont.setOffset(radarPicture.getAttributes().getNamedItem("min").getNodeValue());
        String max = radarPicture.getAttributes().getNamedItem("max").getNodeValue();
        String type = RainbowModel.getValueByName(radarPicture, "projection", "type");
        cont.setType(type);
        String lon0 = RainbowModel.getValueByName(radarPicture, "lon_0", null);
        String lat0 = RainbowModel.getValueByName(radarPicture, "lat_0", null);
        String ellps = RainbowModel.getValueByName(radarPicture, "ellps", null);
        rb.getClass();
        cont.setProjection(rb.parseRAINBOWProjection(lon0, lat0, type, ellps, "6371000"));
        cont.setXsize(RainbowModel.getValueByName(radarPicture, "projection", "size_x"));
        cont.setYsize(RainbowModel.getValueByName(radarPicture, "projection", "size_y"));
        cont.setUlLon(RainbowModel.getValueByName(radarPicture, "projection", "lon_ul"));
        cont.setUlLat(RainbowModel.getValueByName(radarPicture, "projection", "lat_ul"));
        cont.setLrLon(RainbowModel.getValueByName(radarPicture, "projection", "lon_lr"));
        cont.setLrLat(RainbowModel.getValueByName(radarPicture, "projection", "lat_lr"));
        int dataBlobNumber = Integer.parseInt(RainbowModel.getValueByName(radarPicture, "datamap", "blobid"));
        String depth = RainbowModel.getValueByName(radarPicture, "datamap", "depth");
        cont.setDataDepth(depth);
        int dataDepth = Integer.parseInt(depth);
        int flagDepth = Integer.parseInt(RainbowModel.getValueByName(radarPicture, "flagmap", "depth"));
        cont.setFlagDepth(flagDepth);
        int flagBlobNumber = Integer.parseInt(RainbowModel.getValueByName(radarPicture, "flagmap", "blobid"));
        nodeList = rb.getRAINBOWNodesByName(inputDoc, "task", verbose);
        cont.setTask(rb.getRAINBOWMetadataElement(nodeList, "name", verbose));
        cont.setStartepochs(rb.convertRAINBOWDate2Epoch(date, time, verbose));
        cont.setEndepochs(rb.convertRAINBOWDate2Epoch(date, time, verbose));
        cont.setDate(rb.parseRAINBOWDate(date, verbose));
        cont.setTime(rb.parseRAINBOWTime(time, verbose));
        nodeList = rb.getRAINBOWNodesByName(inputDoc, "product", verbose);
        cont.setSwVersion(rb.getRAINBOWMetadataElement(nodeList, "version", verbose));
        nodeList = rb.getRAINBOWNodesByName(inputDoc, "beamwidth", verbose);
        cont.setBeamwidth(rb.getRAINBOWMetadataElement(nodeList, "", verbose));
        nodeList = rb.getRAINBOWNodesByName(inputDoc, "wavelen", verbose);
        cont.setWavelength(rb.getRAINBOWMetadataElement(nodeList, "", verbose));
        nodeList = rb.getRAINBOWNodesByName(inputDoc, "product", verbose);
        String datatype = rb.getRAINBOWMetadataElement(nodeList, "datatype", verbose);
        rb.getClass();
        if (datatype.matches("dBZ")) {
            rb.getClass();
            datatype = "TH";
        } else {
            rb.getClass();
            if (datatype.matches("dBR")) {
                rb.getClass();
                datatype = "RATE";
            } else {
                rb.getClass();
                if (datatype.matches("dBA")) {
                    rb.getClass();
                    datatype = "ACRR";
                } else {
                    rb.getClass();
                    if (datatype.matches("V")) {
                        rb.getClass();
                        datatype = "VRAD";
                    } else {
                        rb.getClass();
                        if (datatype.matches("Height")) {
                            rb.getClass();
                            datatype = "HGHT";
                        }
                    }
                }
            }
        }
        cont.setQuantity(datatype);
        String product = rb.getRAINBOWMetadataElement(nodeList, "name", verbose);
        String pacMethod = null;
        String pacNumProd = null;
        String prodpar = "";
        String res = "";
        nodeList = rb.getRAINBOWNodesByName(inputDoc, "dispres", false);
        res = rb.getRAINBOWMetadataElement(nodeList, "", false);
        if (product.matches("CAPPI")) {
            nodeList = rb.getRAINBOWNodesByName(inputDoc, "algtype", verbose);
            product = rb.getRAINBOWMetadataElement(nodeList, "", verbose);
            nodeList = rb.getRAINBOWNodesByName(inputDoc, "height", verbose);
            prodpar = rb.getRAINBOWMetadataElement(nodeList, "", verbose);
            prodpar = rb.convertKMtoM(rb.convertRAINBOWParam(prodpar));
        } else if (product.matches("SRI")) {
            nodeList = rb.getRAINBOWNodesByName(inputDoc, "sriheight", verbose);
            prodpar = rb.getRAINBOWMetadataElement(nodeList, "", verbose);
            prodpar = rb.convertKMtoM(rb.convertRAINBOWParam(prodpar));
        } else if (product.matches("PAC")) {
            nodeList = rb.getRAINBOWNodesByName(inputDoc, "numprod", verbose);
            pacNumProd = rb.convertRAINBOWParam(rb.getRAINBOWMetadataElement(nodeList, "", verbose));
            nodeList = rb.getRAINBOWNodesByName(inputDoc, "algtype", verbose);
            pacMethod = rb.getRAINBOWMetadataElement(nodeList, "", verbose);
            nodeList = rb.getRAINBOWNodesByName(inputDoc, "timeinterval", verbose);
            prodpar = rb.getRAINBOWMetadataElement(nodeList, "", verbose);
            prodpar = rb.convertTimeInterval(prodpar);
            prodpar = rb.convertRAINBOWParam(prodpar);
            product = "RR";
        } else if (product.matches("PPI")) {
            nodeList = rb.getRAINBOWNodesByName(inputDoc, "ele", verbose);
            prodpar = rb.getRAINBOWMetadataElement(nodeList, "", verbose);
            prodpar = rb.convertRAINBOWParam(prodpar);
        } else if (product.matches("MAX")) {
            nodeList = rb.getRAINBOWNodesByName(inputDoc, "height", verbose);
            prodpar = rb.getRAINBOWMetadataElement(nodeList, "", verbose);
            prodpar = rb.convertKMtoM(rb.convertRAINBOWParam(prodpar));
            nodeList = rb.getRAINBOWNodesByName(inputDoc, "disphorres", verbose);
            res = rb.getRAINBOWMetadataElement(nodeList, "", verbose);
        } else if (product.matches("HSHEAR")) {
            nodeList = rb.getRAINBOWNodesByName(inputDoc, "height", verbose);
            prodpar = rb.getRAINBOWMetadataElement(nodeList, "", verbose);
            prodpar = rb.convertKMtoM(rb.convertRAINBOWParam(prodpar));
        } else if (product.matches("EHT")) {
            product = "ETOP";
            nodeList = rb.getRAINBOWNodesByName(inputDoc, "minz", verbose);
            prodpar = rb.getRAINBOWMetadataElement(nodeList, "", verbose);
            prodpar = rb.convertRAINBOWParam(prodpar);
        } else if (product.matches("VIL")) {
            nodeList = rb.getRAINBOWNodesByName(inputDoc, "height", verbose);
            prodpar = rb.getRAINBOWMetadataElement(nodeList, "", verbose);
            prodpar = rb.convertKMtoM(rb.convertRAINBOWParam(prodpar));
        }
        cont.setProdpar(prodpar);
        cont.setProduct(product);
        cont.setPacMethod(pacMethod);
        cont.setPacNumProd(pacNumProd);
        res = String.valueOf(Double.parseDouble(rb.convertRAINBOWParam(res)) * 1000.0);
        cont.setYscale(res);
        cont.setXscale(res);
        cont.setGain(rb.getRAINBOWGain(cont.getOffset(), max, dataDepth));
        int width = Integer.parseInt(cont.getXsize());
        int height = Integer.parseInt(cont.getYsize());
        int firstBlob = RainbowModel.getMin(flagBlobNumber, dataBlobNumber);
        DataBufferContainer dataBuff = rb.getRainbowDataSection(fileBuff, dataBlobNumber, firstBlob, verbose);
        DataBufferContainer maskBuff = rb.getRainbowDataSection(fileBuff, flagBlobNumber, firstBlob, verbose);
        int[][] infDataBuff = rb.inflate2DRAINBOWDataSection(dataBuff.getDataBuffer(), width, height, verbose);
        byte[] infMaskBuff = rb.inflate1DRAINBOWDataSection(maskBuff.getDataBuffer(), maskBuff.getDataBufferLength(), verbose);
        infDataBuff = rb.createRAINBOWMask(infDataBuff, width, height, infMaskBuff, flagDepth, verbose);
        if (isDirect) {
            if (fileNameOut.isEmpty()) {
                fileNameOut = String.valueOf(cont.getTime()) + cont.getType() + ".h5";
            }
            ModelImageH5.createDescriptor(cont, rb, fileNameOut, infDataBuff, verbose);
        } else {
            String dataDir = rb.hdf.createDirectory("data", verbose);
            StringBuilder stringBuilder = new StringBuilder(String.valueOf(dataDir)).append(File.separator);
            rb.getClass();
            String dataFileName = stringBuilder.append("data1").append(".dat").toString();
            cont.setDataFileName(dataFileName);
            Document od = ModelImageXML.createDescriptor(cont, rb, verbose);
            rb.hdf.saveXMLFile(od, fileNameOut, verbose);
            rb.writeRAINBOWData(infDataBuff, dataFileName, verbose);
        }
        return fileNameOut;
    }
}

