/*
 * Decompiled with CFR 0.152.
 */
package pl.imgw.odimH5.model.rainbow;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import java.util.zip.Deflater;
import ncsa.hdf.object.Group;
import ncsa.hdf.object.h5.H5File;
import ncsa.hdf.object.h5.H5Group;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import pl.imgw.odimH5.model.HDF5Model;
import pl.imgw.odimH5.model.rainbow.PVOLSlicesCont;
import pl.imgw.odimH5.model.rainbow.RainbowModel;
import pl.imgw.odimH5.util.RadarOptions;

public class HDF2RainbowPVOL {
    private String ver = "5.26.5";
    private String type = "vol";
    private String owner = "rainbow";
    private String startangle = "startangle";
    private static final String STOPANGLE = "360";
    private static final double BMWIDTH_SBAND = 0.94;
    private static final double WVLENGTH_SBAND = 0.05309;
    private static final String UNITID_SI = "SI";
    private HashMap<String, String> volume;
    private HashMap<String, String> radarinfo;
    private HashMap<String, String> scan;
    private Vector<String> dataset;
    private Vector<H5Group> datasetG;
    private PVOLSlicesCont[] slices;
    private int size;
    private String date;
    private String time;
    private String radarName = "";
    private int[] nbins;
    private int[] nrays;
    private HDF5Model hdf;
    private RainbowModel rb;
    private RadarOptions[] options;
    private boolean verbose;
    private H5File inputFile;
    private String outputFileName;

    public HDF2RainbowPVOL(String outputFileName, String inputFileName, boolean verbose, RainbowModel rb, RadarOptions[] options) throws Exception {
        this.rb = rb;
        this.options = options;
        this.verbose = verbose;
        this.outputFileName = outputFileName;
        this.hdf = rb.getHDFModel();
        this.inputFile = this.hdf.openHDF5File(inputFileName);
        Group rootHDF = this.hdf.getHDF5RootGroup(this.inputFile, verbose);
        this.dataset = new Vector();
        this.datasetG = new Vector();
        List memberList = rootHDF.getMemberList();
        for (H5Group group : memberList) {
            if (!group.getName().contains("dataset")) continue;
            this.dataset.add(group.getName());
            this.datasetG.add(group);
        }
        this.size = this.dataset.size();
        this.volume = this.makeVolAtributes(rootHDF);
        this.radarinfo = this.makeRadarinfo(rootHDF);
        this.slices = this.makeSlices(rootHDF);
        this.makeRayinfoData(360);
        this.makeXMLHead();
        this.hdf.closeHDF5File(this.inputFile);
    }

    private HashMap<String, String> makeVolAtributes(Group rootHDF) {
        HashMap<String, String> vol = new HashMap<String, String>();
        this.rb.getClass();
        String d = this.hdf.getHDF5StringValue(rootHDF, "what", "date", this.verbose);
        this.rb.getClass();
        String t = this.hdf.getHDF5StringValue(rootHDF, "what", "time", this.verbose);
        if (this.outputFileName.isEmpty()) {
            this.outputFileName = String.valueOf(d) + t + "00dBZ.vol";
        }
        this.date = String.valueOf(d.substring(0, 4)) + "-" + d.substring(4, 6) + "-" + d.substring(6, 8);
        this.time = String.valueOf(t.substring(0, 2)) + ":" + t.substring(2, 4) + ":" + t.substring(4, 6);
        vol.put("datetime", String.valueOf(this.date) + "T" + this.time);
        vol.put("type", this.type);
        vol.put("owner", this.owner);
        return vol;
    }

    private HashMap<String, String> makeRadarinfo(Group rootHDF) {
        HashMap<String, String> radar = new HashMap<String, String>();
        this.rb.getClass();
        double alt = this.hdf.getHDF5DoubleValue(rootHDF, "where", "height", this.verbose);
        this.rb.getClass();
        double lat = this.hdf.getHDF5DoubleValue(rootHDF, "where", "lat", this.verbose);
        this.rb.getClass();
        double lon = this.hdf.getHDF5DoubleValue(rootHDF, "where", "lon", this.verbose);
        this.rb.getClass();
        double bmwidth = this.hdf.getHDF5DoubleValue(rootHDF, "how", "beamwidth", this.verbose);
        this.rb.getClass();
        double wvlength = this.hdf.getHDF5DoubleValue(rootHDF, "how", "wavelength", this.verbose);
        this.rb.getClass();
        String source = this.hdf.getHDF5StringValue(rootHDF, "what", "source", this.verbose);
        if (bmwidth == 0.0) {
            bmwidth = 0.94;
        }
        if (wvlength == 0.0) {
            wvlength = 0.05309;
        }
        int i = 0;
        while (i < this.options.length) {
            if (source.contains(this.options[i].getRadarWMOName())) {
                this.radarName = this.options[i].getRadarName();
                break;
            }
            ++i;
        }
        if (this.radarName.isEmpty()) {
            System.out.println("Add name of radar number " + source + " to options.xml");
            return null;
        }
        radar.put("alt", String.valueOf(alt));
        radar.put("lat", String.valueOf(lat));
        radar.put("lon", String.valueOf(lon));
        radar.put("beamwidth", String.valueOf(bmwidth));
        radar.put("wavelen", String.valueOf(wvlength));
        radar.put("id", this.radarName);
        return radar;
    }

    private PVOLSlicesCont[] makeSlices(Group rootHDF) {
        PVOLSlicesCont[] slices = new PVOLSlicesCont[this.size];
        this.nbins = new int[this.size];
        this.nrays = new int[this.size];
        int i = 0;
        while (i < this.size) {
            slices[i] = new PVOLSlicesCont();
            this.rb.getClass();
            double elangle = this.hdf.getHDF5DoubleLeafValue(rootHDF, this.dataset.get(i), "where", "elangle", this.verbose);
            this.rb.getClass();
            double rstart = this.hdf.getHDF5DoubleLeafValue(rootHDF, this.dataset.get(i), "where", "rstart", this.verbose);
            this.rb.getClass();
            double rscale = this.hdf.getHDF5DoubleLeafValue(rootHDF, this.dataset.get(i), "where", "rscale", this.verbose);
            rscale /= 1000.0;
            this.rb.getClass();
            int nbins = this.hdf.getHDF5IntLeafValue(rootHDF, this.dataset.get(i), "where", "nbins", this.verbose);
            this.rb.getClass();
            int nrays = this.hdf.getHDF5IntLeafValue(rootHDF, this.dataset.get(i), "where", "nrays", this.verbose);
            this.nbins[i] = nbins;
            this.nrays[i] = nrays;
            this.rb.getClass();
            int a1gate = this.hdf.getHDF5IntLeafValue(rootHDF, this.dataset.get(i), "where", "a1gate", this.verbose);
            Group group = (Group)this.datasetG.get(i);
            this.rb.getClass();
            this.rb.getClass();
            double gain = this.hdf.getHDF5DoubleLeafValue(group, "data1", "what", "gain", this.verbose);
            Group group2 = (Group)this.datasetG.get(i);
            this.rb.getClass();
            this.rb.getClass();
            double offset = this.hdf.getHDF5DoubleLeafValue(group2, "data1", "what", "offset", this.verbose);
            double stoprange = (double)nbins * rscale;
            slices[i].slice.put("posangle", String.valueOf(elangle));
            slices[i].slice.put("stoprange", String.valueOf(stoprange));
            slices[i].slice.put("startangle", String.valueOf(rstart));
            slices[i].slice.put("stopangle", STOPANGLE);
            slices[i].slice.put("rangestep", String.valueOf(rscale));
            slices[i].slice.put("rangesamp", "4");
            slices[i].rayinfo.put("blobid", String.valueOf(i * 2));
            slices[i].rayinfo.put("rays", String.valueOf(nrays));
            slices[i].rayinfo.put("depth", "16");
            slices[i].rawdata.put("blobid", String.valueOf(i * 2 + 1));
            slices[i].rawdata.put("rays", String.valueOf(nrays));
            slices[i].rawdata.put("type", "dBZ");
            slices[i].rawdata.put("bins", String.valueOf(nbins));
            slices[i].rawdata.put("min", "-31.5");
            slices[i].rawdata.put("max", "95.5");
            slices[i].rawdata.put("depth", "8");
            this.rb.getClass();
            StringBuilder stringBuilder = new StringBuilder(String.valueOf("/")).append(this.dataset.get(i)).append("/");
            this.rb.getClass();
            StringBuilder stringBuilder2 = stringBuilder.append("data1").append("/");
            this.rb.getClass();
            String path = stringBuilder2.append("data").toString();
            int[][] dataset = this.hdf.getHDF5Dataset(this.inputFile, path, nrays, nbins, this.verbose);
            dataset = this.hdf.transposeArray(dataset, nbins, nrays);
            slices[i].setDatasetFromHdf(dataset);
            ++i;
        }
        return slices;
    }

    private void makeXMLHead() {
        Document od = this.rb.hdf.createXMLDocumentObject(this.verbose);
        Element root = od.createElement("volume");
        root.setAttribute("version", this.ver);
        root.setAttribute("datetime", String.valueOf(this.date) + "T" + this.time);
        root.setAttribute("type", this.type);
        root.setAttribute("owner", this.owner);
        od.appendChild(root);
        Element rinfoTag = od.createElement("radarinfo");
        rinfoTag.setAttribute("alt", this.radarinfo.get("alt"));
        rinfoTag.setAttribute("lon", this.radarinfo.get("lon"));
        rinfoTag.setAttribute("lat", this.radarinfo.get("lat"));
        rinfoTag.setAttribute("id", this.radarinfo.get("id"));
        rinfoTag.appendChild(this.rb.makeTag("name", this.radarName, od));
        rinfoTag.appendChild(this.rb.makeTag("beamwidth", this.radarinfo.get("beamwidth"), od));
        rinfoTag.appendChild(this.rb.makeTag("wavelen", this.radarinfo.get("wavelen"), od));
        root.appendChild(rinfoTag);
        Element scanTag = od.createElement("scan");
        scanTag.setAttribute("name", String.valueOf(this.radarinfo.get("id")) + "." + this.type);
        scanTag.setAttribute("time", this.time);
        scanTag.setAttribute("date", this.date);
        root.appendChild(scanTag);
        scanTag.appendChild(this.rb.makeTag("unitid", UNITID_SI, od));
        Element pargroup = od.createElement("pargroup");
        pargroup.setAttribute("refid", "sdfbase");
        pargroup.appendChild(this.rb.makeTag("numele", String.valueOf(this.size), od));
        scanTag.appendChild(pargroup);
        int i = 0;
        while (i < this.size) {
            Element sliceTag = od.createElement("slice");
            sliceTag.setAttribute("refid", String.valueOf(i));
            sliceTag.appendChild(this.rb.makeTag("posangle", this.slices[i].slice.get("posangle"), od));
            sliceTag.appendChild(this.rb.makeTag("stoprange", this.slices[i].slice.get("stoprange"), od));
            sliceTag.appendChild(this.rb.makeTag("startangle", this.slices[i].slice.get("startangle"), od));
            sliceTag.appendChild(this.rb.makeTag("stopangle", this.slices[i].slice.get("stopangle"), od));
            sliceTag.appendChild(this.rb.makeTag("rangestep", this.slices[i].slice.get("rangestep"), od));
            sliceTag.appendChild(this.rb.makeTag("rangesamp", this.slices[i].slice.get("rangesamp"), od));
            Element sliceDataTag = od.createElement("slicedata");
            sliceDataTag.setAttribute("time", this.time);
            sliceDataTag.setAttribute("date", this.date);
            Element rayinfoTag = od.createElement("rayinfo");
            rayinfoTag.setAttribute("refid", this.startangle);
            rayinfoTag.setAttribute("blobid", this.slices[i].rayinfo.get("blobid"));
            rayinfoTag.setAttribute("rays", this.slices[i].rayinfo.get("rays"));
            rayinfoTag.setAttribute("depth", this.slices[i].rayinfo.get("depth"));
            sliceDataTag.appendChild(rayinfoTag);
            Element rawdataTag = od.createElement("rawdata");
            rawdataTag.setAttribute("blobid", this.slices[i].rawdata.get("blobid"));
            rawdataTag.setAttribute("rays", this.slices[i].rawdata.get("rays"));
            rawdataTag.setAttribute("type", this.slices[i].rawdata.get("type"));
            rawdataTag.setAttribute("bins", this.slices[i].rawdata.get("bins"));
            rawdataTag.setAttribute("min", this.slices[i].rawdata.get("min"));
            rawdataTag.setAttribute("max", this.slices[i].rawdata.get("max"));
            rawdataTag.setAttribute("depth", this.slices[i].rawdata.get("depth"));
            sliceDataTag.appendChild(rawdataTag);
            sliceTag.appendChild(sliceDataTag);
            scanTag.appendChild(sliceTag);
            ++i;
        }
        Comment comment = od.createComment(" END XML ");
        od.appendChild(comment);
        this.rb.hdf.saveXMLFile(od, this.outputFileName, this.verbose);
        int i2 = 0;
        while (i2 < this.size) {
            this.saveData(this.outputFileName, this.makeRayinfoData(this.nrays[i2]), i2 * 2, "qt");
            this.saveData(this.outputFileName, this.getByteArray(this.slices[i2].getDatasetFromHdf(), this.nbins[i2], this.nrays[i2]), i2 * 2 + 1, "qt");
            ++i2;
        }
    }

    private byte[] getByteArray(int[][] dataArray, int x, int y) {
        byte[] output = new byte[x * y];
        int index = 0;
        int i = 0;
        while (i < x) {
            int j = 0;
            while (j < y) {
                output[index] = (byte)dataArray[i][j];
                ++index;
                ++j;
            }
            ++i;
        }
        return output;
    }

    private void saveData(String fileName, byte[] data, int blobNumber, String compresion) {
        Deflater compressor = new Deflater();
        compressor.setLevel(9);
        compresion = "qt";
        compressor.setInput(data);
        compressor.finish();
        ByteArrayOutputStream bos = new ByteArrayOutputStream(data.length);
        byte[] buf = new byte[1024];
        while (!compressor.finished()) {
            int count = compressor.deflate(buf);
            bos.write(buf, 0, count);
        }
        try {
            bos.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        byte[] compressedData = bos.toByteArray();
        int orgsize = data.length;
        int compsize = compressedData.length + 4;
        String beg = "<BLOB blobid=\"" + blobNumber + "\" size=\"" + compsize + "\" compression=\"" + compresion + "\">";
        String end = "</BLOB>";
        try {
            RandomAccessFile rf = new RandomAccessFile(fileName, "rw");
            FileChannel fc = rf.getChannel();
            fc.position(fc.size());
            fc.write(ByteBuffer.wrap((String.valueOf(beg) + "\n").getBytes()));
            byte[] bytes = ByteBuffer.allocate(4).putInt(orgsize).array();
            fc.write(ByteBuffer.wrap(bytes));
            fc.write(ByteBuffer.wrap(compressedData));
            fc.write(ByteBuffer.wrap(("\n" + end + "\n").getBytes()));
            fc.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private byte[] makeRayinfoData(int size) {
        byte[] array = new byte[size * 2];
        if (size == 0) {
            size = 360;
        }
        int step = 182;
        if (size < 360) {
            step = 65535 / size;
        }
        int i = 0;
        while (i < size) {
            int a = i % 360 * step + 1;
            byte[] bytes = ByteBuffer.allocate(2).putChar((char)a).array();
            array[i * 2] = bytes[0];
            array[i * 2 + 1] = bytes[1];
            ++i;
        }
        return array;
    }

    public String getOutputFileName() {
        return this.outputFileName;
    }

    public String getRadarName() {
        return this.radarName;
    }
}

