/*
 * Decompiled with CFR 0.152.
 */
package pl.imgw.odimH5.model;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Writer;
import java.util.List;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import ncsa.hdf.hdf5lib.H5;
import ncsa.hdf.hdf5lib.HDF5Constants;
import ncsa.hdf.hdf5lib.exceptions.HDF5Exception;
import ncsa.hdf.object.Attribute;
import ncsa.hdf.object.Dataset;
import ncsa.hdf.object.FileFormat;
import ncsa.hdf.object.Group;
import ncsa.hdf.object.HObject;
import ncsa.hdf.object.h5.H5File;
import org.apache.xerces.parsers.DOMParser;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import pl.imgw.odimH5.util.MessageLogger;

public class HDF5Model {
    private static final String XML_ATTR = "attribute";
    private static final String H5_ROOT = "/";
    private static final String H5_GROUP = "group";
    private static final String H5_DATASET = "dataset";
    private static final String H5_OBJECT_NAME = "name";
    private static final String H5_OBJECT_CLASS = "class";
    private static final String H5_GZIP_LEVEL = "gzip_level";
    private static final String H5_DATA_CHUNK = "chunk";
    private static final String H5_DIMENSIONS = "dimensions";
    private static final String XML_VERSION = "1.0";
    private static final String XML_ENCODING = "UTF-8";
    private static final String H5_CLASS = "CLASS";
    private static final String H5_IM_VER = "IMAGE_VERSION";
    private MessageLogger msgl;

    public MessageLogger getMessageLogger() {
        return this.msgl;
    }

    public void setMessageLogger(MessageLogger msgl) {
        this.msgl = msgl;
    }

    public NodeList parseDescriptor(String descriptorFile, boolean verbose) {
        NodeList nodeList = null;
        try {
            DOMParser parser = new DOMParser();
            parser.parse(descriptorFile);
            Document doc = parser.getDocument();
            nodeList = doc.getChildNodes();
            this.msgl.showMessage("Parsing descriptor file: " + descriptorFile, verbose);
        }
        catch (Exception e) {
            this.msgl.showMessage("Failed to parse descriptor: " + e.getMessage(), verbose);
        }
        return nodeList;
    }

    public void H5FcreateFromXML(NodeList nodeList, int cur_group_id, boolean verbose) {
        Node currentNode = null;
        NamedNodeMap attributes = null;
        String attr_name = null;
        String attr_class = null;
        String attr_value = null;
        int child_group_id = -1;
        int dataspace_id = -1;
        int dataset_id = -1;
        int status = -1;
        int i = 0;
        while (i < nodeList.getLength()) {
            currentNode = nodeList.item(i);
            if (currentNode.hasAttributes() && currentNode.getNodeName().equals(XML_ATTR)) {
                try {
                    attributes = currentNode.getAttributes();
                    attr_name = attributes.getNamedItem(H5_OBJECT_NAME).getNodeValue();
                    attr_class = attributes.getNamedItem(H5_OBJECT_CLASS).getNodeValue();
                    attr_value = currentNode.getFirstChild().getNodeValue();
                    this.H5Acreate_any_wrap(cur_group_id, attr_name, attr_class, attr_value, verbose);
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
            }
            if (currentNode.hasAttributes() && currentNode.getNodeName().equals(H5_DATASET)) {
                attributes = currentNode.getAttributes();
                attr_value = currentNode.getFirstChild().getNodeValue();
                attr_name = attributes.getNamedItem(H5_DIMENSIONS).getNodeValue();
                int dim_x = Integer.parseInt(attr_name.substring(0, attr_name.lastIndexOf("x")));
                int dim_y = Integer.parseInt(attr_name.substring(attr_name.lastIndexOf("x") + 1, attr_name.length()));
                dataspace_id = this.H5Screate_simple_wrap(2, dim_x, dim_y, null, verbose);
                attr_name = attributes.getNamedItem(H5_DATA_CHUNK).getNodeValue();
                int chunk = Integer.parseInt(attr_name.substring(0, attr_name.lastIndexOf("x")));
                attr_name = attributes.getNamedItem(H5_GZIP_LEVEL).getNodeValue();
                int gZipLevel = Integer.parseInt(attr_name);
                attr_name = attributes.getNamedItem(H5_OBJECT_NAME).getNodeValue();
                dataset_id = this.H5Dcreate_wrap(cur_group_id, attr_name, HDF5Constants.H5T_STD_U8BE, dataspace_id, chunk, gZipLevel, verbose);
                attr_name = attributes.getNamedItem(H5_CLASS).getNodeValue();
                this.H5Acreate_any_wrap(dataset_id, H5_CLASS, "string", attr_name, verbose);
                attr_name = attributes.getNamedItem(H5_IM_VER).getNodeValue();
                this.H5Acreate_any_wrap(dataset_id, H5_IM_VER, "string", attr_name, verbose);
                int[][] dataBuff = this.readData(attr_value, verbose);
                status = this.H5Dwrite_wrap(dataset_id, HDF5Constants.H5T_NATIVE_INT, HDF5Constants.H5S_ALL, HDF5Constants.H5S_ALL, HDF5Constants.H5P_DEFAULT, dataBuff, verbose);
                status = this.H5Dclose_wrap(dataset_id, verbose);
                status = this.H5Sclose_wrap(dataspace_id, verbose);
            }
            if (currentNode.hasChildNodes() && currentNode.getNodeName().equals(H5_GROUP)) {
                String groupName = this.getXMLAttributeValue(currentNode, H5_OBJECT_NAME);
                child_group_id = this.H5Gcreate_wrap(cur_group_id, groupName, 0, verbose);
                NodeList childNodes = currentNode.getChildNodes();
                this.H5FcreateFromXML(childNodes, child_group_id, verbose);
                status = this.H5Gclose_wrap(child_group_id, verbose);
            }
            ++i;
        }
    }

    public int H5Fcreate_wrap(String filename, int access_mode, int create_id, int access_id, boolean verbose) {
        int file_id = -1;
        try {
            file_id = H5.H5Fcreate((String)filename, (int)access_mode, (int)create_id, (int)access_id);
            this.msgl.showMessage("Created new HDF5 file: " + filename + ", ID=" + file_id, verbose);
        }
        catch (HDF5Exception hdf5e) {
            this.msgl.showMessage("[HDF5 error] Failed to create HDF5 file: " + hdf5e.getMessage(), verbose);
        }
        catch (Exception e) {
            this.msgl.showMessage("[Error] Failed to create HDF5 file: " + e.getMessage(), verbose);
        }
        return file_id;
    }

    public int H5Fclose_wrap(int file_id, boolean verbose) {
        int status = -1;
        try {
            status = H5.H5Fclose((int)file_id);
            this.msgl.showMessage("Closing HDF5 file: ID=" + file_id, verbose);
        }
        catch (HDF5Exception hdf5e) {
            this.msgl.showMessage("[HDF5 error] Failed to close HDF5 file: " + hdf5e.getMessage(), verbose);
        }
        catch (Exception e) {
            this.msgl.showMessage("[Error]Failed to close HDF5 file: " + e.getMessage(), verbose);
        }
        return status;
    }

    public int H5Gcreate_wrap(int file_id, String name, int size_hint, boolean verbose) {
        int group_id = -1;
        try {
            group_id = H5.H5Gcreate((int)file_id, (String)name, (int)size_hint);
            this.msgl.showMessage("Created HDF5 group: " + name + ", ID=" + group_id, verbose);
        }
        catch (HDF5Exception hdf5e) {
            this.msgl.showMessage("[HDF5 error] Failed to create HDF5 group: " + hdf5e.getMessage(), verbose);
        }
        catch (Exception e) {
            this.msgl.showMessage("[Error] Failed to create HDF5 group: " + e.getMessage(), verbose);
        }
        return group_id;
    }

    public int H5Gclose_wrap(int group_id, boolean verbose) {
        int status = -1;
        try {
            status = H5.H5Gclose((int)group_id);
            this.msgl.showMessage("Closing HDF5 group: ID=" + group_id, verbose);
        }
        catch (HDF5Exception hdf5e) {
            this.msgl.showMessage("[HDF5 error] Failed to close HDF5 group: " + hdf5e.getMessage(), verbose);
        }
        catch (Exception e) {
            this.msgl.showMessage("[Error] Failed to close HDF5 group: " + e.getMessage(), verbose);
        }
        return status;
    }

    public void H5Acreate_any_wrap(int group_id, String attr_name, String attr_class, String attr_value, boolean verbose) {
        Object[] value;
        if (attr_value == null || attr_value.isEmpty()) {
            return;
        }
        int size = -1;
        int attribute_id = -1;
        int dataspace_id = this.H5Screate_wrap(HDF5Constants.H5S_SCALAR, verbose);
        if (attr_class.equals("long")) {
            attribute_id = this.H5Acreate_numeric_wrap(group_id, attr_name, HDF5Constants.H5T_NATIVE_INT, dataspace_id, HDF5Constants.H5P_DEFAULT, verbose);
            value = new long[]{Long.parseLong(attr_value)};
            this.H5Awrite_wrap(attribute_id, HDF5Constants.H5T_NATIVE_INT, value, verbose);
        }
        if (attr_class.equals("double")) {
            attribute_id = this.H5Acreate_numeric_wrap(group_id, attr_name, HDF5Constants.H5T_NATIVE_DOUBLE, dataspace_id, HDF5Constants.H5P_DEFAULT, verbose);
            value = new double[1];
            value[0] = (long)Double.parseDouble(attr_value);
            this.H5Awrite_wrap(attribute_id, HDF5Constants.H5T_NATIVE_DOUBLE, value, verbose);
        }
        if (attr_class.equals("string") || attr_class.equals("sequence")) {
            byte[] t_attr_buf = attr_value.getBytes();
            size = t_attr_buf.length + 1;
            byte[] attr_buf = new byte[size];
            int i = 0;
            while (i < t_attr_buf.length) {
                attr_buf[i] = t_attr_buf[i];
                ++i;
            }
            attr_buf[size - 1] = 0;
            int dataset_id = this.H5Tcopy_wrap(HDF5Constants.H5T_C_S1, verbose);
            this.H5Tset_size_wrap(dataset_id, size, verbose);
            attribute_id = this.H5Acreate_string_wrap(group_id, attr_name, dataset_id, dataspace_id, HDF5Constants.H5P_DEFAULT, verbose);
            this.H5Awrite_wrap(attribute_id, dataset_id, attr_buf, verbose);
        }
        this.H5Aclose_wrap(attribute_id, verbose);
        this.H5Sclose_wrap(dataspace_id, verbose);
    }

    public int H5Screate_wrap(int datatype_id, boolean verbose) {
        int dataspace_id = -1;
        try {
            dataspace_id = H5.H5Screate((int)datatype_id);
            this.msgl.showMessage("Created HDF5 dataspace: ID=" + dataspace_id + ", datatype ID=" + datatype_id, verbose);
        }
        catch (HDF5Exception hdf5e) {
            this.msgl.showMessage("[HDF5 error] Failed to create HDF5 dataspace: " + hdf5e.getMessage(), verbose);
        }
        catch (Exception e) {
            this.msgl.showMessage("[Error] Failed to create HDF5 dataspace: " + e.getMessage(), verbose);
        }
        return dataspace_id;
    }

    public int H5Screate_simple_wrap(int rank, int dim_x, int dim_y, long[] maxdims, boolean verbose) {
        int dataspace_id = -1;
        long[] dims = new long[]{dim_x, dim_y};
        try {
            dataspace_id = H5.H5Screate_simple((int)rank, (long[])dims, (long[])maxdims);
            this.msgl.showMessage("Created HDF5 dataspace: ID=" + dataspace_id, verbose);
        }
        catch (HDF5Exception hdf5e) {
            this.msgl.showMessage("[HDF5 error] Failed to create HDF5 dataspace: " + hdf5e.getMessage(), verbose);
        }
        catch (Exception e) {
            this.msgl.showMessage("[Error] Failed to create HDF5 dataspace: " + e.getMessage(), verbose);
        }
        return dataspace_id;
    }

    public int H5Sclose_wrap(int dataspace_id, boolean verbose) {
        int status = -1;
        try {
            status = H5.H5Sclose((int)dataspace_id);
            this.msgl.showMessage("Closing HDF5 dataspace: ID=" + dataspace_id, verbose);
        }
        catch (HDF5Exception hdf5e) {
            this.msgl.showMessage("[HDF5 Error] Failed to close HDF5 dataspace: " + hdf5e.getMessage(), verbose);
        }
        catch (Exception e) {
            this.msgl.showMessage("[Error] Failed to close HDF5 dataspace: " + e.getMessage(), verbose);
        }
        return status;
    }

    public int H5Acreate_numeric_wrap(int group_id, String attr_name, int datatype_id, int dataspace_id, int create_plist, boolean verbose) {
        int attribute_id = -1;
        try {
            attribute_id = H5.H5Acreate((int)group_id, (String)attr_name, (int)datatype_id, (int)dataspace_id, (int)create_plist);
            this.msgl.showMessage("Created HDF5 attribute: " + attr_name + ", ID=" + attribute_id + ", group ID=" + group_id, verbose);
        }
        catch (HDF5Exception hdf5e) {
            this.msgl.showMessage("[HDF5 Error] Failed to create HDF5 numeric attribute: " + hdf5e.getMessage(), verbose);
        }
        catch (Exception e) {
            this.msgl.showMessage("[Error] Failed to create HDF5 numeric attribute: " + e.getMessage(), verbose);
        }
        return attribute_id;
    }

    public int H5Acreate_string_wrap(int group_id, String attr_name, int dataset_id, int dataspace_id, int create_plist, boolean verbose) {
        int attribute_id = -1;
        try {
            attribute_id = H5.H5Acreate((int)group_id, (String)attr_name, (int)dataset_id, (int)dataspace_id, (int)create_plist);
            this.msgl.showMessage("Created HDF5 attribute: " + attr_name + ", ID=" + attribute_id + ", group ID=" + group_id, verbose);
        }
        catch (HDF5Exception hdf5e) {
            this.msgl.showMessage("[HDF5 Error] Failed to create HDF5 string attribute: " + hdf5e.getMessage(), verbose);
        }
        catch (Exception e) {
            this.msgl.showMessage("[Error] Failed to create HDF5 string attribute: " + e.getMessage(), verbose);
        }
        return attribute_id;
    }

    public int H5Awrite_wrap(int attr_id, int datatype_id, Object buf, boolean verbose) {
        int status = -1;
        try {
            status = H5.H5Awrite((int)attr_id, (int)datatype_id, (Object)buf);
            this.msgl.showMessage("Writing HDF5 attribute: ID=" + attr_id + ", datatype ID=" + datatype_id, verbose);
        }
        catch (HDF5Exception hdf5e) {
            this.msgl.showMessage("[HDF5 Error] Failed to write HDF5 attribute: " + hdf5e.getMessage(), verbose);
        }
        catch (Exception e) {
            this.msgl.showMessage("[Error] Failed to write HDF5 attribute: " + e.getMessage(), verbose);
        }
        return status;
    }

    public int H5Aclose_wrap(int attribute_id, boolean verbose) {
        int status = -1;
        try {
            status = H5.H5Aclose((int)attribute_id);
        }
        catch (HDF5Exception hdf5e) {
            this.msgl.showMessage("[HDF5 Error] Failed to close HDF5 attribute: " + hdf5e.getMessage(), verbose);
        }
        catch (Exception e) {
            this.msgl.showMessage("[Error] Failed to close HDF5 attribute: " + e.getMessage(), verbose);
        }
        return status;
    }

    public int H5Tset_size_wrap(int dataset_id, int size, boolean verbose) {
        int status = -1;
        try {
            H5.H5Tset_size((int)dataset_id, (int)size);
            this.msgl.showMessage("Setting dataset size: ID=" + dataset_id + ", size=" + size, verbose);
        }
        catch (HDF5Exception hdf5e) {
            this.msgl.showMessage("[HDF5 Error] Failed to set HDF5 dataspace size: " + hdf5e.getMessage(), verbose);
        }
        catch (Exception e) {
            this.msgl.showMessage("[Error] Failed to set HDF5 dataspace size: " + e.getMessage(), verbose);
        }
        return status;
    }

    public int H5Tcopy_wrap(int datatype_id, boolean verbose) {
        int dataset_id = -1;
        try {
            dataset_id = H5.H5Tcopy((int)datatype_id);
        }
        catch (HDF5Exception hdf5e) {
            this.msgl.showMessage("[HDF5 Error] Failed to copy HDF5 datatype: " + hdf5e.getMessage(), verbose);
        }
        catch (Exception e) {
            this.msgl.showMessage("[Error] Failed to copy HDF5 datatype: " + e.getMessage(), verbose);
        }
        return dataset_id;
    }

    public int H5Dcreate_wrap(int file_id, String group_name, int datatype_id, int dataspace_id, int chunk, int gZipLevel, boolean verbose) {
        int status = -1;
        int dataset_id = -1;
        long[] cdims = new long[]{chunk, chunk};
        try {
            int create_plist_id = H5.H5Pcreate((int)HDF5Constants.H5P_DATASET_CREATE);
            status = H5.H5Pset_chunk((int)create_plist_id, (int)2, (long[])cdims);
            status = H5.H5Pset_deflate((int)create_plist_id, (int)gZipLevel);
            dataset_id = H5.H5Dcreate((int)file_id, (String)group_name, (int)datatype_id, (int)dataspace_id, (int)create_plist_id);
            this.msgl.showMessage("Creating HDF5 dataset: ID=" + dataset_id + ", datatype ID=" + datatype_id, verbose);
        }
        catch (HDF5Exception hdf5e) {
            this.msgl.showMessage("[HDF5 Error] Failed to create HDF5 dataset: " + hdf5e.getMessage(), verbose);
        }
        catch (Exception e) {
            this.msgl.showMessage("[Error] Failed to create HDF5 dataset: " + e.getMessage(), verbose);
        }
        return dataset_id;
    }

    public int H5Dwrite_wrap(int dataset_id, int mem_type_id, int mem_space_id, int file_space_id, int xfer_plist_id, Object buf, boolean verbose) {
        int status = -1;
        try {
            status = H5.H5Dwrite((int)dataset_id, (int)mem_type_id, (int)mem_space_id, (int)file_space_id, (int)xfer_plist_id, (Object)buf);
            this.msgl.showMessage("Writing HDF5 dataset: ID=" + dataset_id, verbose);
        }
        catch (HDF5Exception hdf5e) {
            this.msgl.showMessage("[HDF5 Error] Failed to write HDF5 dataset: " + hdf5e.getMessage(), verbose);
        }
        catch (Exception e) {
            this.msgl.showMessage("[Error] Failed to write HDF5 dataset: " + e.getMessage(), verbose);
        }
        return status;
    }

    public int H5Dclose_wrap(int dataset_id, boolean verbose) {
        int status = -1;
        try {
            status = H5.H5Dclose((int)dataset_id);
            this.msgl.showMessage("Closing HDF5 dataset: ID=" + dataset_id, verbose);
        }
        catch (HDF5Exception hdf5e) {
            this.msgl.showMessage("[HDF5 Error] Failed to close HDF5 dataset: " + hdf5e.getMessage(), verbose);
        }
        catch (Exception e) {
            this.msgl.showMessage("[HDF5 Error] Failed to close HDF5 dataset: " + e.getMessage(), verbose);
        }
        return status;
    }

    public String getXMLAttributeValue(Node node, String xmlAttributeName) {
        NamedNodeMap attributes = node.getAttributes();
        return attributes.getNamedItem(xmlAttributeName).getNodeValue();
    }

    public NodeList getTopLevelNodes(NodeList rootNodes) {
        NodeList topLevelNodes = null;
        Node curNode = null;
        NamedNodeMap attributes = null;
        String nodeValue = null;
        int i = 0;
        while (i < rootNodes.getLength()) {
            curNode = rootNodes.item(i);
            if (curNode.hasAttributes() && (nodeValue = (attributes = curNode.getAttributes()).getNamedItem(H5_OBJECT_NAME).getNodeValue()).equals(H5_ROOT)) {
                topLevelNodes = curNode.getChildNodes();
            }
            ++i;
        }
        return topLevelNodes;
    }

    public void appendRootPath(NodeList topLevelNodes) {
        Node curNode = null;
        NamedNodeMap attributes = null;
        String nodeValue = null;
        String nodeValueWithRoot = null;
        int i = 0;
        while (i < topLevelNodes.getLength()) {
            curNode = topLevelNodes.item(i);
            if (curNode.hasAttributes()) {
                attributes = curNode.getAttributes();
                nodeValue = attributes.getNamedItem(H5_OBJECT_NAME).getNodeValue();
                nodeValueWithRoot = H5_ROOT + nodeValue;
                attributes.getNamedItem(H5_OBJECT_NAME).setNodeValue(nodeValueWithRoot);
            }
            ++i;
        }
    }

    public byte[] readDataFile(String fileName, boolean verbose) {
        File fin = new File(fileName);
        int file_len = (int)fin.length();
        byte[] file_buf = new byte[file_len];
        try {
            FileInputStream fis = new FileInputStream(fileName);
            fis.read(file_buf, 0, file_len);
            fis.close();
            this.msgl.showMessage("Reading input data file: " + fileName, verbose);
        }
        catch (IOException e) {
            this.msgl.showMessage("Error while reading input data file: " + fileName, verbose);
        }
        return file_buf;
    }

    public Document createXMLDocumentObject(boolean verbose) {
        Document doc = null;
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            doc = builder.newDocument();
        }
        catch (ParserConfigurationException e) {
            this.msgl.showMessage("Error while creating XML document object: " + e.getMessage(), verbose);
        }
        return doc;
    }

    public void saveXMLFile(Document doc, String fileName, boolean verbose) {
        try {
            OutputFormat format = new OutputFormat(doc);
            format.setVersion(XML_VERSION);
            format.setEncoding(XML_ENCODING);
            format.setIndenting(true);
            XMLSerializer serializer = new XMLSerializer(format);
            serializer.setOutputCharStream((Writer)new FileWriter(fileName));
            serializer.serialize(doc);
        }
        catch (Exception e) {
            this.msgl.showMessage("Error while saving XML file: " + e.getMessage(), verbose);
        }
    }

    public String createDirectory(String dirName, boolean verbose) {
        String path = null;
        File f = new File(dirName);
        path = f.getPath();
        if (f.exists()) {
            this.msgl.showMessage("Directory exists: " + dirName, verbose);
        } else {
            boolean success = f.mkdir();
            if (!success) {
                this.msgl.showMessage("Failed to create directory: " + dirName, verbose);
            }
        }
        return path;
    }

    public byte[] intToByteArray(int value) {
        byte[] b = new byte[4];
        int i = 0;
        while (i < 4) {
            int offset = (b.length - 1 - i) * 8;
            b[i] = (byte)(value >>> offset & 0xFF);
            ++i;
        }
        return b;
    }

    public int[][] readData(String fileName, boolean verbose) {
        this.msgl.showMessage("Reading data file: " + fileName, verbose);
        int[][] dataBuff = null;
        try {
            FileInputStream fis = new FileInputStream(fileName);
            ObjectInputStream ois = new ObjectInputStream(fis);
            dataBuff = (int[][])ois.readObject();
            ois.close();
        }
        catch (Exception e) {
            this.msgl.showMessage("Failed to read data file: " + e.getMessage(), verbose);
        }
        return dataBuff;
    }

    public int[][] transposeArray(int[][] intArray, int rays, int bins) {
        int[][] newArray = new int[rays][bins];
        int i = 0;
        while (i < bins) {
            int j = 0;
            while (j < rays) {
                newArray[j][i] = intArray[i][j];
                ++j;
            }
            ++i;
        }
        return newArray;
    }

    public int[][] shiftAzimuths(int[][] intArray, int rays, int bins, int startingAzimuth) {
        startingAzimuth = rays - startingAzimuth;
        int[][] newArray = new int[bins][rays];
        int newJ = 0;
        int i = 0;
        while (i < bins) {
            int j = 0;
            while (j < rays) {
                newJ = (j + startingAzimuth) % rays;
                newArray[i][newJ] = intArray[i][j];
                ++j;
            }
            ++i;
        }
        return newArray;
    }

    public boolean verifyHDF5File(String fileName) {
        boolean res;
        try {
            FileFormat fileFormat = FileFormat.getFileFormat((String)"HDF5");
            H5File inputFile = (H5File)fileFormat.open(fileName, 0);
            inputFile.open();
            res = true;
        }
        catch (Exception e) {
            res = false;
        }
        return res;
    }

    public H5File openHDF5File(String fileName) {
        FileFormat fileFormat = FileFormat.getFileFormat((String)"HDF5");
        H5File inputFile = null;
        try {
            inputFile = (H5File)fileFormat.open(fileName, 0);
            inputFile.open();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return inputFile;
    }

    public void closeHDF5File(H5File inputfile) {
        try {
            inputfile.close();
        }
        catch (HDF5Exception e) {
            e.printStackTrace();
        }
    }

    public Group getHDF5RootGroup(H5File inputFile, boolean verbose) {
        Group root = null;
        try {
            root = (Group)((DefaultMutableTreeNode)inputFile.getRootNode()).getUserObject();
        }
        catch (Exception e) {
            this.msgl.showMessage("I/O error: Error while opening HDF5 file", verbose);
        }
        return root;
    }

    public String getHDF5StringValue(Group grp, String grpName, String attrName, boolean verbose) {
        List grpsList = grp.getMemberList();
        HObject obj = null;
        String[] ret = null;
        try {
            int i = 0;
            while (i < grpsList.size()) {
                obj = (HObject)grpsList.get(i);
                if (obj.toString().matches(grpName)) {
                    List attrsList = obj.getMetadata();
                    int j = 0;
                    while (j < attrsList.size()) {
                        Attribute attr = (Attribute)attrsList.get(j);
                        if (attr.getName().matches(attrName)) {
                            ret = (String[])attr.getValue();
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }
        catch (Exception e) {
            this.msgl.showMessage("I/O error: Error while retrieving HDF5 string attribute value", verbose);
        }
        if (ret == null) {
            return "";
        }
        return ret[0];
    }

    public int getHDF5IntegerValue(Group grp, String grpName, String attrName, boolean verbose) {
        List grpsList = grp.getMemberList();
        HObject obj = null;
        int[] ret = null;
        try {
            int i = 0;
            while (i < grpsList.size()) {
                obj = (HObject)grpsList.get(i);
                if (obj.toString().matches(grpName)) {
                    List attrsList = obj.getMetadata();
                    int j = 0;
                    while (j < attrsList.size()) {
                        Attribute attr = (Attribute)attrsList.get(j);
                        if (attr.getName().matches(attrName)) {
                            ret = (int[])attr.getValue();
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }
        catch (Exception e) {
            this.msgl.showMessage("I/O error: Error while retrieving HDF5 integer attribute value", verbose);
        }
        if (ret == null) {
            return 0;
        }
        return ret[0];
    }

    public double getHDF5DoubleValue(Group grp, String grpName, String attrName, boolean verbose) {
        List grpsList = grp.getMemberList();
        HObject obj = null;
        double[] ret = null;
        try {
            int i = 0;
            while (i < grpsList.size()) {
                obj = (HObject)grpsList.get(i);
                if (obj.toString().matches(grpName)) {
                    List attrsList = obj.getMetadata();
                    int j = 0;
                    while (j < attrsList.size()) {
                        Attribute attr = (Attribute)attrsList.get(j);
                        if (attr.getName().matches(attrName)) {
                            ret = (double[])attr.getValue();
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }
        catch (Exception e) {
            this.msgl.showMessage("I/O error: Error while retrieving HDF5 double attribute value", verbose);
        }
        if (ret == null) {
            return this.getHDF5FloatValue(grp, grpName, attrName, verbose);
        }
        return ret[0];
    }

    public float getHDF5FloatValue(Group grp, String grpName, String attrName, boolean verbose) {
        List grpsList = grp.getMemberList();
        HObject obj = null;
        float[] ret = null;
        try {
            int i = 0;
            while (i < grpsList.size()) {
                obj = (HObject)grpsList.get(i);
                if (obj.toString().matches(grpName)) {
                    List attrsList = obj.getMetadata();
                    int j = 0;
                    while (j < attrsList.size()) {
                        Attribute attr = (Attribute)attrsList.get(j);
                        if (attr.getName().matches(attrName)) {
                            ret = (float[])attr.getValue();
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }
        catch (Exception e) {
            this.msgl.showMessage("I/O error: Error while retrieving HDF5 float attribute value", verbose);
        }
        if (ret == null) {
            return 0.0f;
        }
        return ret[0];
    }

    public String getHDF5StringLeafValue(Group grp, String grpName, String leafGrpName, String leafAttrName, boolean verbose) {
        List grpsList = grp.getMemberList();
        HObject obj = null;
        String[] ret = null;
        try {
            int i = 0;
            while (i < grpsList.size()) {
                obj = (HObject)grpsList.get(i);
                if (obj.toString().matches(grpName)) {
                    Group g = (Group)grpsList.get(i);
                    List leafGrpsList = g.getMemberList();
                    int j = 0;
                    while (j < leafGrpsList.size()) {
                        obj = (HObject)leafGrpsList.get(j);
                        if (obj.toString().matches(leafGrpName)) {
                            List leafAttrsList = obj.getMetadata();
                            int k = 0;
                            while (k < leafAttrsList.size()) {
                                Attribute leafAttr = (Attribute)leafAttrsList.get(k);
                                if (leafAttr.getName().matches(leafAttrName)) {
                                    ret = (String[])leafAttr.getValue();
                                }
                                ++k;
                            }
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }
        catch (Exception e) {
            this.msgl.showMessage("I/O error: Error while retrieving HDF5 string attribute value", verbose);
        }
        if (ret == null) {
            return null;
        }
        return ret[0];
    }

    public float getHDF5FloatLeafValue(Group grp, String grpName, String leafGrpName, String leafAttrName, boolean verbose) {
        List grpsList = grp.getMemberList();
        HObject obj = null;
        float[] ret = null;
        try {
            int i = 0;
            while (i < grpsList.size()) {
                obj = (HObject)grpsList.get(i);
                if (obj.toString().matches(grpName)) {
                    Group g = (Group)grpsList.get(i);
                    List leafGrpsList = g.getMemberList();
                    int j = 0;
                    while (j < leafGrpsList.size()) {
                        obj = (HObject)leafGrpsList.get(j);
                        if (obj.toString().matches(leafGrpName)) {
                            List leafAttrsList = obj.getMetadata();
                            int k = 0;
                            while (k < leafAttrsList.size()) {
                                Attribute leafAttr = (Attribute)leafAttrsList.get(k);
                                if (leafAttr.getName().matches(leafAttrName)) {
                                    ret = (float[])leafAttr.getValue();
                                }
                                ++k;
                            }
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }
        catch (Exception e) {
            this.msgl.showMessage("I/O error: Error while retrieving HDF5 float attribute value", verbose);
        }
        if (ret == null) {
            return 0.0f;
        }
        return ret[0];
    }

    public int getHDF5IntLeafValue(Group grp, String grpName, String leafGrpName, String leafAttrName, boolean verbose) {
        List grpsList = grp.getMemberList();
        HObject obj = null;
        int[] ret = null;
        try {
            int i = 0;
            while (i < grpsList.size()) {
                obj = (HObject)grpsList.get(i);
                if (obj.toString().matches(grpName)) {
                    Group g = (Group)grpsList.get(i);
                    List leafGrpsList = g.getMemberList();
                    int j = 0;
                    while (j < leafGrpsList.size()) {
                        obj = (HObject)leafGrpsList.get(j);
                        if (obj.toString().matches(leafGrpName)) {
                            List leafAttrsList = obj.getMetadata();
                            int k = 0;
                            while (k < leafAttrsList.size()) {
                                Attribute leafAttr = (Attribute)leafAttrsList.get(k);
                                if (leafAttr.getName().matches(leafAttrName)) {
                                    ret = (int[])leafAttr.getValue();
                                }
                                ++k;
                            }
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }
        catch (Exception e) {
            this.msgl.showMessage("I/O error: Error while retrieving HDF5 integer attribute value", verbose);
        }
        if (ret == null) {
            return 0;
        }
        return ret[0];
    }

    public double getHDF5DoubleLeafValue(Group grp, String grpName, String leafGrpName, String leafAttrName, boolean verbose) {
        List grpsList = grp.getMemberList();
        HObject obj = null;
        double[] ret = null;
        try {
            int i = 0;
            while (i < grpsList.size()) {
                obj = (HObject)grpsList.get(i);
                if (obj.toString().matches(grpName)) {
                    Group g = (Group)grpsList.get(i);
                    List leafGrpsList = g.getMemberList();
                    int j = 0;
                    while (j < leafGrpsList.size()) {
                        obj = (HObject)leafGrpsList.get(j);
                        if (obj.toString().matches(leafGrpName)) {
                            List leafAttrsList = obj.getMetadata();
                            int k = 0;
                            while (k < leafAttrsList.size()) {
                                Attribute leafAttr = (Attribute)leafAttrsList.get(k);
                                if (leafAttr.getName().matches(leafAttrName)) {
                                    ret = (double[])leafAttr.getValue();
                                }
                                ++k;
                            }
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }
        catch (Exception e) {
            this.msgl.showMessage("I/O error: Error while retrieving HDF5 double attribute value", verbose);
        }
        if (ret == null) {
            return this.getHDF5FloatLeafValue(grp, grpName, leafGrpName, leafAttrName, verbose);
        }
        return ret[0];
    }

    public int[][] getHDF5Dataset(H5File inputFile, String datasetPath, int width, int height, boolean verbose) {
        int[][] dataArray2D = new int[width][height];
        try {
            Dataset dataset = (Dataset)inputFile.get(datasetPath);
            byte[] dataArray = (byte[])dataset.read();
            int count = 0;
            int x = 0;
            while (x < width) {
                int y = 0;
                while (y < height) {
                    count = y * width + x;
                    dataArray2D[x][y] = dataArray[count] & 0xFF;
                    ++y;
                }
                ++x;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.msgl.showMessage("I/O error: Error while retrieving HDF5 dataset", verbose);
        }
        return dataArray2D;
    }

    public String parseHDF5Date(String dateStr, String delimiter) {
        String year;
        String date = new String("");
        date = year = dateStr.substring(0, 4);
        date = String.valueOf(date) + delimiter;
        String month = dateStr.substring(4, 6);
        date = String.valueOf(date) + month;
        date = String.valueOf(date) + delimiter;
        String day = dateStr.substring(6, 8);
        date = String.valueOf(date) + day;
        return date;
    }

    public String parseHDF5Time(String timeStr, String delimiter) {
        String hour;
        String time = new String("");
        time = hour = timeStr.substring(0, 2);
        time = String.valueOf(time) + delimiter;
        String minute = timeStr.substring(2, 4);
        time = String.valueOf(time) + minute;
        time = String.valueOf(time) + delimiter;
        String second = timeStr.substring(4, 6);
        time = String.valueOf(time) + second;
        return time;
    }
}

