/*
 * Decompiled with CFR 0.152.
 */
package pl.imgw.odimH5.controller;

import eu.baltrad.frame.model.BaltradFrame;
import eu.baltrad.frame.model.BaltradFrameHandler;
import ncsa.hdf.hdf5lib.HDF5Constants;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import pl.imgw.odimH5.model.HDF5Model;
import pl.imgw.odimH5.model.rainbow.HDF2RainbowPVOL;
import pl.imgw.odimH5.model.rainbow.ModelImage;
import pl.imgw.odimH5.model.rainbow.ModelRHI;
import pl.imgw.odimH5.model.rainbow.ModelVP;
import pl.imgw.odimH5.model.rainbow.Rainbow2HDFPVOL;
import pl.imgw.odimH5.model.rainbow.RainbowModel;
import pl.imgw.odimH5.util.CommandLineArgsParser;
import pl.imgw.odimH5.util.LocalFeeder;
import pl.imgw.odimH5.util.LogsHandler;
import pl.imgw.odimH5.util.MessageLogger;
import pl.imgw.odimH5.util.OptionsHandler;
import pl.imgw.odimH5.util.RadarOptions;

public class DataProcessorController {
    public static final String RAINBOW_PLATFORM = "RAINBOW";
    private HDF5Model hdf;
    private RainbowModel rainbow;
    private CommandLineArgsParser cmd;
    private MessageLogger msgl;
    boolean verbose;

    public void startProcessor(String[] args) throws Exception {
        this.cmd.parseCommandLineArgs(args);
        this.verbose = this.cmd.hasArgument("v");
        Document doc = OptionsHandler.loadOptions(this.msgl, this.verbose);
        if (this.cmd.hasArgument("i") && this.cmd.hasArgument("o") && !this.cmd.hasArgument("f") && !this.cmd.hasArgument("p")) {
            this.msgl.showMessage("Conversion from xml descriptor mode selected", true);
            int file_id = -1;
            int status = -1;
            NodeList topLevelNodes = this.hdf.getTopLevelNodes(this.hdf.parseDescriptor(this.cmd.getArgumentValue("i"), this.verbose));
            this.hdf.appendRootPath(topLevelNodes);
            file_id = this.hdf.H5Fcreate_wrap(this.cmd.getArgumentValue("o"), HDF5Constants.H5F_ACC_TRUNC, HDF5Constants.H5P_DEFAULT, HDF5Constants.H5P_DEFAULT, this.verbose);
            this.hdf.H5FcreateFromXML(topLevelNodes, file_id, this.verbose);
            status = this.hdf.H5Fclose_wrap(file_id, this.verbose);
            this.msgl.showMessage("Conversion completed.", this.verbose);
        } else if (this.cmd.hasArgument("i") && this.cmd.hasArgument("f") && this.cmd.hasArgument("p")) {
            String fileNameOut = "";
            String fileNameIn = this.cmd.getArgumentValue("i");
            if (this.cmd.hasArgument("o")) {
                fileNameOut = this.cmd.getArgumentValue("o");
            }
            this.msgl.showMessage("Conversion mode selected", this.verbose);
            if (doc == null) {
                OptionsHandler.exampleOptionXML();
                System.out.println("\nCreate and/or edit file options.xml");
                return;
            }
            RadarOptions[] options = OptionsHandler.getRadarOptions(doc);
            byte[] fileBuff = this.hdf.readDataFile(this.cmd.getArgumentValue("i"), this.verbose);
            if (this.cmd.getArgumentValue("p").equals(RAINBOW_PLATFORM)) {
                if (this.cmd.getArgumentValue("f").equals(this.rainbow.PVOL)) {
                    if (fileNameIn.endsWith("vol")) {
                        Rainbow2HDFPVOL vol = new Rainbow2HDFPVOL(fileNameOut, fileBuff, this.verbose, this.rainbow, options);
                        if (!vol.correct) {
                            return;
                        }
                        if (vol.getOutputFileName().endsWith("hdf") || vol.getOutputFileName().endsWith("h5")) {
                            vol.makeH5();
                        } else {
                            vol.makeXML();
                        }
                    } else if (fileNameIn.endsWith("h5") || fileNameIn.endsWith("hdf")) {
                        HDF2RainbowPVOL hDF2RainbowPVOL = new HDF2RainbowPVOL(fileNameOut, fileNameIn, this.verbose, this.rainbow, options);
                    }
                } else if (this.cmd.getArgumentValue("f").equals(this.rainbow.IMAGE)) {
                    fileNameOut = ModelImage.createDescriptor(fileNameOut, fileBuff, this.verbose, this.rainbow, options);
                } else if (this.cmd.getArgumentValue("f").equals(this.rainbow.VP)) {
                    fileNameOut = ModelVP.createDescriptor(fileNameOut, fileBuff, this.verbose, this.rainbow, options);
                } else if (this.cmd.getArgumentValue("f").equals(this.rainbow.RHI)) {
                    fileNameOut = ModelRHI.createDescriptor(fileNameOut, fileBuff, this.verbose, this.rainbow, options);
                }
            }
            if (!fileNameOut.isEmpty()) {
                this.msgl.showMessage("Descriptor preparation completed.", this.verbose);
            }
        } else if (this.cmd.hasArgument("c")) {
            this.msgl.showMessage("Operational feeder mode selected", true);
            if (doc == null) {
                OptionsHandler.exampleOptionXML();
                System.out.println("\nCreate and/or edit file options.xml");
                return;
            }
            LocalFeeder worker = new LocalFeeder(doc, this.rainbow, this.hdf, this.msgl, this.verbose);
            try {
                worker.start();
            }
            catch (Exception e) {
                LogsHandler.saveProgramLogs(e.getMessage());
                e.printStackTrace();
            }
        } else if (this.cmd.hasArgument("i") && this.cmd.hasArgument("a") && this.cmd.hasArgument("s") && this.cmd.hasArgument("r")) {
            this.msgl.showMessage("Sending file to server", this.verbose);
            BaltradFrameHandler bfh = new BaltradFrameHandler(this.cmd.getArgumentValue("a"));
            String a = bfh.createDataHdr("multipart/form-data", this.cmd.getArgumentValue("s"), this.cmd.getArgumentValue("r"), this.cmd.getArgumentValue("i"));
            BaltradFrame bf = new BaltradFrame(a, this.cmd.getArgumentValue("i"));
            bfh.handleBF(bf);
        }
    }

    public HDF5Model getHDFModel() {
        return this.hdf;
    }

    public void setHDFModel(HDF5Model proc) {
        this.hdf = proc;
    }

    public RainbowModel getRAINBOWModel() {
        return this.rainbow;
    }

    public void setRAINBOWModel(RainbowModel rainbow) {
        this.rainbow = rainbow;
    }

    public CommandLineArgsParser getCmdParser() {
        return this.cmd;
    }

    public void setCmdParser(CommandLineArgsParser cmd) {
        this.cmd = cmd;
    }

    public MessageLogger getMessageLogger() {
        return this.msgl;
    }

    public void setMessageLogger(MessageLogger msgl) {
        this.msgl = msgl;
    }
}

